terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/rds/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

data "terraform_remote_state" "account" {
  backend = "s3"

  config {
    bucket  = "${var.account}"
    key     = "tfstate/feed/terraform/accounts/${var.account}"
    region  = "${var.region}"
    profile = "${var.account}"
  }
}

module "rds" {
  source = "../../../modules/rds"

  # Environment
  account     = "${var.account}"
  environment = "${var.environment}"
  name        = "oracle"
  owner       = "creatorbusiness@twitch.tv"
  region      = "${var.region}"
  team        = "Creator Business"
  team_code   = "feed"
  twitch_subnets_sg = "${data.terraform_remote_state.account.twitch_subnets_sg}"

  # Specifies if the RDS instance is multi-availability-zone
  rds_multi_az = "false" 

  # Specifies if a snapshot is *not* created before the DB is deleted
  rds_skip_final_snapshot = "true"

  # Specifies the amount of allocated storage space (in GB)
  allocated_storage = 60

  # The amount of seconds a condition must be true for a Cloudwatch alarm to fire
  period = 60

  # Occupied space percentage above which a Cloudwatch alarm will fire
  threshold_percent = 80

  # ARN for SNS topic to be notified when a Cloudwatch alarm fires
  action_arn = "arn:aws:sns:us-west-2:724951484461:pagerduty_events"
}
