# Module for provisioning the per environment resources that all events services will share.

# Environment
variable "team" {}

variable "environment" {}

variable "sandstorm_role_arn" {
  description = "The sandstorm role ARN that events services will need to assume to access sandstorm secrets"
}

variable "build_deployment_role_name" {
  description = "The name of the IAM role that jenkins assumes when running a deploy"
}

resource "aws_iam_policy" "sandstorm_policy" {
  name        = "${var.team}-${var.environment}-sandstorm"
  path        = "/"
  description = "Allow a service to assume the ${var.team} ${var.environment} sandstorm role, allowing the service to access that role's secrets."

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "sts:AssumeRole"
      ],
      "Resource": [
        "${var.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

# TODO: Grant the permission on specific resources
# TODO: Update terraform/core module so that we get this policy from there.
resource "aws_iam_policy" "get_deploy_logs_policy" {
  name        = "${var.team}-${var.environment}-get-deploy-logs"
  path        = "/"
  description = "Allow the build role to get a task's logs during a deploy."

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "logs:GetLogEvents"
      ],
      "Resource": [
        "*"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "build_role_get_deploy_logs" {
  role       = "${var.build_deployment_role_name}"
  policy_arn = "${aws_iam_policy.get_deploy_logs_policy.arn}"
}

output sandstorm_policy_arn {
  value = "${aws_iam_policy.sandstorm_policy.arn}"
}
