# Module for defining the elasticache
# TODO: Once we merge the canary & production environments, we should put this into terraform/modules/gea/elasticache.tf

# Environment

variable "account" {}
variable "region" {}
variable "name" {}
variable "owner" {}
variable "team" {}
variable "environment" {}

variable "elasticache_node_type" {}
variable "elasticache_node_count" {}

data "terraform_remote_state" "account" {
  backend = "s3"

  config {
    bucket  = "${var.account}"
    key     = "tfstate/feed/terraform/accounts/${var.account}"
    region  = "${var.region}"
    profile = "${var.account}"
  }
}

resource "aws_elasticache_subnet_group" "gea_cache" {
  # Subnet group names can only use alphanumeric and hyphens
  name        = "gea-${var.environment}"
  description = "Subnet group for memcached cluster"
  subnet_ids  = ["${split(",", "${data.terraform_remote_state.account.private_subnets}")}"]
}

resource "aws_elasticache_cluster" "gea_cache" {
  # Cluster IDs must be less than 20 characters long and only contain lowercase characters or hyphens
  cluster_id           = "gea-${var.environment}"
  engine               = "memcached"
  port                 = 11211
  node_type            = "${var.elasticache_node_type}"
  num_cache_nodes      = "${var.elasticache_node_count}"
  apply_immediately    = true
  parameter_group_name = "default.memcached1.4"
  security_group_ids   = ["${data.terraform_remote_state.account.twitch_subnets_sg}"]
  subnet_group_name    = "${aws_elasticache_subnet_group.gea_cache.name}"
  tags {
    Owner = "${var.owner}"
    Team = "${var.team}"
  }
}
