resource "aws_sqs_queue" "notifications_dead_letter_queue" {
  name = "${var.team}-${var.environment}-notification-deadletter"
}

resource "aws_sqs_queue" "notifications_queue" {
  name                       = "${var.team}-${var.environment}-notification"
  visibility_timeout_seconds = 900

  redrive_policy = <<EOF
  {
    "deadLetterTargetArn": "${aws_sqs_queue.notifications_dead_letter_queue.arn}",
    "maxReceiveCount": 3
  }
EOF
}

# Consul key that contains the URL of the notifications SQS queue, for services to reference
module "consulconf" {
  source      = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//consulconf?ref=v0.5.1"
  service     = "${var.name}"
  team        = "${var.team}"
  environment = "${var.environment}"
  key         = "notifications_queue_url"
  value       = "${aws_sqs_queue.notifications_queue.id}"
}

// Channel event SQS queue
// It facilitates publishing channel live event updates to pubsub.  A service component periodically enqueues
// channel IDs of channels that recently had a change in their current live event.  A set of workers read the
// channel IDs from the queue, and publish those channels' current live events to pubsub.
resource "aws_sqs_queue" "channel_event_queue" {
  name                       = "${var.team}-${var.environment}-channel-event"
  visibility_timeout_seconds = 900

  redrive_policy = <<EOF
  {
    "deadLetterTargetArn": "${aws_sqs_queue.channel_event_dead_letter_queue.arn}",
    "maxReceiveCount": 3
  }
EOF
}

// Dead letter SQS queue that recieves messages from the channel event queue that could not be processed.
resource "aws_sqs_queue" "channel_event_dead_letter_queue" {
  name = "${var.team}-${var.environment}-channel-event-deadletter"
}

# Consul key that contains the URL of the channel event SQS queue, for services to reference
module "channel_event_queue_consulconf" {
  source      = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//consulconf?ref=v0.5.1"
  service     = "${var.name}"
  team        = "${var.team}"
  environment = "${var.environment}"
  key         = "channel_event.sqssource.queue_url"
  value       = "${aws_sqs_queue.channel_event_queue.id}"
}
