variable "account" {}
variable "region" {}
variable "alb_name" {}
variable "alb_arn" {}
variable "check_period" {}
variable "rate_5xx_threshold" {}
variable "latency_threshold" {}
variable "action_arn" {}

provider "aws" {
  alias = "${var.account}"
  region = "${var.region}"
  profile = "${var.account}"
}

# Create an alarm for when there is a spike in 5XX's
resource "aws_cloudwatch_metric_alarm" "alb_rate_5xx_alarm" {
  provider = "aws.${var.account}"
  alarm_name = "${var.alb_name}-alb-5xx-rate"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods = 5
  metric_name = "HTTPCode_Target_5XX_Count"
  namespace = "AWS/ApplicationELB"
  period = "${var.check_period}"
  statistic = "Sum"
  threshold = "${var.rate_5xx_threshold}"
  alarm_description = "Triggered when there are more than ${var.rate_5xx_threshold} 5XX's per minute"
  alarm_actions = ["${var.action_arn}"]
  treat_missing_data = "notBreaching"
  dimensions {
    LoadBalancer = "${var.alb_arn}"
  }
}

# Create an alarm for when latency gets too high
resource "aws_cloudwatch_metric_alarm" "alb_latency_alarm" {
  provider = "aws.${var.account}"
  alarm_name = "${var.alb_name}-alb-latency"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods = 5
  metric_name = "TargetResponseTime"
  namespace = "AWS/ApplicationELB"
  period = "${var.check_period}"
  extended_statistic = "p90.00"
  threshold = "${var.latency_threshold}" # Milliseconds
  alarm_description = "Triggered when latency rises above ${var.latency_threshold} milliseconds on average"
  alarm_actions = ["${var.action_arn}"]
  treat_missing_data = "notBreaching"
  dimensions {
    LoadBalancer = "${var.alb_arn}"
  }
}
