variable rate {} 
variable gea_endpoint {}

variable team {}
variable name {}
variable environment {}

variable subnets {}
variable security_groups {}

resource "aws_iam_role" "iam_for_lambda" {
  name = "${var.team}-${var.name}-${var.environment}-lambda"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "lambda_policy_attach" {
  role       = "${aws_iam_role.iam_for_lambda.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole"
}

resource "aws_lambda_function" "lambda_post" {
  filename         = "../../../index.zip"
  function_name    = "${var.team}-${var.name}-${var.environment}-notifier"
  role             = "${aws_iam_role.iam_for_lambda.arn}"
  handler          = "lambda.triggerNotifications"
  source_code_hash = "${base64sha256(file("../../../index.zip"))}"
  runtime          = "nodejs6.10"

  environment {
    variables = {
      GEA_ENDPOINT = "${var.gea_endpoint}"
    }
  }

  vpc_config {
    subnet_ids = ["${split(",", "${var.subnets}")}"]
    security_group_ids = ["${var.security_groups}"]
  }
}

/* Taken from: https://github.com/hashicorp/terraform/issues/4393#issuecomment-194287540*/ 

resource "aws_cloudwatch_event_rule" "cron" {
    name = "cron-call-lambda"
    description = "Fires every $rate minute(s)"
    schedule_expression = "${var.rate}"
}

resource "aws_cloudwatch_event_target" "call_lambda" {
    rule = "${aws_cloudwatch_event_rule.cron.name}"
    target_id = "lambda_post"
    arn = "${aws_lambda_function.lambda_post.arn}"
}

resource "aws_lambda_permission" "allow_cloudwatch_to_call_lambda_post" {
    statement_id = "AllowExecutionFromCloudWatch"
    action = "lambda:InvokeFunction"
    function_name = "${aws_lambda_function.lambda_post.function_name}"
    principal = "events.amazonaws.com"
    source_arn = "${aws_cloudwatch_event_rule.cron.arn}"
}

