resource "aws_ssm_parameter" "key_value_canary" {
  count    = "${length(var.canary) == 0 ? 0 : 1 }"
  provider = "aws.canary"
  name     = "/settings/${var.team_name}/canary/${var.service_name}/${var.suffix}"
  type     = "String"
  value    = "${var.canary}"

  description = "${var.description}"

  tags {
    Owner   = "${var.owner}"
    Project = "${var.project}"
    Team    = "${var.team_display_name}"
  }
}

resource "aws_ssm_parameter" "key_value_development" {
  count    = "${length(var.development) == 0 ? 0 : 1 }"
  provider = "aws.development"
  name     = "/settings/${var.team_name}/development/${var.service_name}/${var.suffix}"
  type     = "String"
  value    = "${var.development}"

  description = "${var.description}"

  tags {
    Owner   = "${var.owner}"
    Project = "${var.project}"
    Team    = "${var.team_display_name}"
  }
}

resource "aws_ssm_parameter" "key_value_integration" {
  count    = "${length(var.integration) == 0 ? 0 : 1 }"
  provider = "aws.integration"
  name     = "/settings/${var.team_name}/integration/${var.service_name}/${var.suffix}"
  type     = "String"
  value    = "${var.integration}"

  description = "${var.description}"

  tags {
    Owner   = "${var.owner}"
    Project = "${var.project}"
    Team    = "${var.team_display_name}"
  }
}

resource "aws_ssm_parameter" "key_value_staging" {
  count    = "${length(var.staging) == 0 ? 0 : 1 }"
  provider = "aws.staging"
  name     = "/settings/${var.team_name}/staging/${var.service_name}/${var.suffix}"
  type     = "String"
  value    = "${var.staging}"

  description = "${var.description}"

  tags {
    Owner   = "${var.owner}"
    Project = "${var.project}"
    Team    = "${var.team_display_name}"
  }
}

resource "aws_ssm_parameter" "key_value_production" {
  count    = "${length(var.production) == 0 ? 0 : 1 }"
  provider = "aws.production"
  name     = "/settings/${var.team_name}/production/${var.service_name}/${var.suffix}"
  type     = "String"
  value    = "${var.production}"

  description = "${var.description}"

  tags {
    Owner   = "${var.owner}"
    Project = "${var.project}"
    Team    = "${var.team_display_name}"
  }
}
