# This module is meant to be used along with the uploads module.  The uploads module
# creates an S3 bucket to hold uploaded images, and this module adds a bucket policy
# to that S3 bucket.

# These resources have been factored out of the uploads module because we have some
# environments where we need to allow public access to the bucket (so a CDN can access
# the images), and other environments where we can't allow public access.  Environments
# that need to grant public access should use this module, while environments that
# don't need to grant public access should use the upload_bucket_policy_without_cdn module.

variable "upload_s3_bucket_id" {}

variable "upload_s3_bucket_arn" {}

variable "upload_service_arns" {
  type = "list"
}

variable "reader_service_arns" {
  type = "list"
}

data "aws_iam_policy_document" "s3_access" {
  statement {
    effect = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["${concat(var.upload_service_arns, var.reader_service_arns)}"]
    }

    actions   = ["s3:GetObject*", "s3:PutObject*"]
    resources = ["${var.upload_s3_bucket_arn}/*"]
  }

  statement {
    effect = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["*"]
    }

    actions   = ["s3:GetObject"]
    resources = ["${var.upload_s3_bucket_arn}/*"]
  }
}

resource "aws_s3_bucket_policy" "uploader_access" {
  bucket = "${var.upload_s3_bucket_id}"
  policy = "${data.aws_iam_policy_document.s3_access.json}"
}
