# Accept a VPC peering connection request from another AWS account, and update the
# route tables to allow traffic to that account.

variable "vpc_peering_connection_id" {}
variable "sender_aws_account_alias" {}
variable "sender_cidr_block" {}
variable "vpc_id" {}

resource "aws_vpc_peering_connection_accepter" "peer" {
  vpc_peering_connection_id = "${var.vpc_peering_connection_id}"
  auto_accept               = "true"

  tags {
    Name = "${var.sender_aws_account_alias}"
  }
}

data "aws_subnet_ids" "subnet_ids" {
  vpc_id = "${var.vpc_id}"
}

data "aws_route_tables" "route_tables" {
  vpc_id = "${var.vpc_id}"

  filter {
    name   = "association.subnet-id"
    values = ["${data.aws_subnet_ids.subnet_ids.ids}"]
  }
}

resource "aws_route" "subnet_to_peered_account_route" {
  count                     = "${length(data.aws_route_tables.route_tables.ids)}"
  route_table_id            = "${data.aws_route_tables.route_tables.ids[count.index]}"
  destination_cidr_block    = "${var.sender_cidr_block}"
  vpc_peering_connection_id = "${var.vpc_peering_connection_id}"
}
