terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/events/parameters/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "admin_users" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.admin_users"
  description = "Comma separated list of user IDs that can perform any operation"

  canary      = "123333107,104314641,3240079,21457162,48910598,148386486,147798184,40529315,76846095,138289128,57138723,40243430,40863935,133643350,30531236,48934668,43445044,54083979,15817895,41896185,37004958,35009065,20137474,68301096,23429329,41257196,28337972,42372839,153817938"
  development = ""
  integration = ""
  staging     = ""
  production  = "123333107,104314641,3240079,21457162,48910598,148386486,147798184,40529315,76846095,138289128,57138723,40243430,40863935,133643350,30531236,48934668,43445044,54083979,15817895,41896185,37004958,35009065,20137474,68301096,23429329,41257196,28337972,42372839,153817938"
}

module "can_create_events_on_any_channel_users" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.can_create_events_on_any_channel_users"
  description = "Comma separated list of user IDs that can create events of any channel"

  canary      = "123333107,104314641,3240079,21457162,48910598,148386486,147798184,40529315,76846095,138289128,57138723,40243430,40863935,133643350,30531236,48934668,43445044,54083979,15817895,41896185,37004958,35009065,20137474,68301096,23429329,41257196,28337972,42372839,153817938"
  development = ""
  integration = ""
  staging     = ""
  production  = "123333107,104314641,3240079,21457162,48910598,148386486,147798184,40529315,76846095,138289128,57138723,40243430,40863935,133643350,30531236,48934668,43445044,54083979,15817895,41896185,37004958,35009065,20137474,68301096,23429329,41257196,28337972,42372839,153817938"
}

module "channel_event_window_lower_bound" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.channel_event_window_lower_bound"
  description = "A Go time.Duration string that indicates the amount of time to look back when querying for events that have recently started or ended."

  canary      = "10m"
  development = "10m"
  integration = "10m"
  staging     = "10m"
  production  = "10m"
}

module "log_all_update_event_errors" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.log_all_update_event_errors"
  description = "true to log errors returned by the update event endpoint, otherwise false"

  canary      = "true"
  development = ""
  integration = ""
  staging     = ""
  production  = "true"
}

module "suggestions_config_by_game" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.suggestions.config_by_game"
  description = "suggestions_config_by_game defines the channels that should be considered when serving up popular future, live and past events for a given game."

  canary      = "{ \"21779\": { \"__comment_not_used\": \"League of Legends\",\"featured_channels\": [\"36029255\"] },\"488552\": {\"__comment_not_used\": \"Overwatch\",\"featured_channels\": [\"59980349\", \"137512364\", \"156567621\"] },\"497571\": {\"__comment_not_used\": \"Wrestling\",\"featured_channels\": [\"143314130\", \"89991985\", \"178262623\", \"122743991\", \"69521718\", \"142399923\", \"161101369\", \"159538868\", \"173434178\", \"177214194\", \"158567594\", \"86698086\", \"40314423\", \"62111158\", \"41777024\", \"186794521\", \"142399923\"] },\"138585\": {\"__comment_not_used\": \"Hearthstone\",\"featured_channels\": [\"42776357\", \"189752674\", \"189910210\", \"54681827\", \"43780497\", \"65348435\", \"76903277\", \"147239905\", \"44891082\", \"44891403\", \"88607946\", \"118076662\"] } }"
  development = ""
  integration = ""
  staging     = ""
  production  = "{ \"21779\": { \"__comment_not_used\": \"League of Legends\",\"featured_channels\": [\"36029255\"] },\"488552\": {\"__comment_not_used\": \"Overwatch\",\"featured_channels\": [\"59980349\", \"137512364\", \"156567621\"] },\"497571\": {\"__comment_not_used\": \"Wrestling\",\"featured_channels\": [\"143314130\", \"89991985\", \"178262623\", \"122743991\", \"69521718\", \"142399923\", \"161101369\", \"159538868\", \"173434178\", \"177214194\", \"158567594\", \"86698086\", \"40314423\", \"62111158\", \"41777024\", \"186794521\", \"142399923\"] },\"138585\": {\"__comment_not_used\": \"Hearthstone\",\"featured_channels\": [\"42776357\", \"189752674\", \"189910210\", \"54681827\", \"43780497\", \"65348435\", \"76903277\", \"147239905\", \"44891082\", \"44891403\", \"88607946\", \"118076662\"] } }"
}

module "uploads_upload_timeout" {
  source      = "../modules/parameters"
  suffix      = "${var.service_name}.uploads.upload_timeout"
  description = "A Go time.Duration string that indicates how long to try uploading an image before canceling the operation."

  canary      = "8s"
  development = ""
  integration = ""
  staging     = ""
  production  = "8s"
}
