#!/bin/sh

echo "Downloading Sandstorm-Agent"

yum-config-manager -y --enable artifactory
yum clean all
yum install -y sandstorm-agent || echo "Failed to install sandstorm-agent"

eval $(/opt/elasticbeanstalk/containerfiles/support/generate_env | sed 's/$/;/')

# Replaces ENVIRONMENT with $ENVIRONMENT environment variable
sed -i "s/{ENVIRONMENT}/${ENVIRONMENT}/g" /etc/sandstorm-agent/templates.d/*
sed -i "s/{ENVIRONMENT}/$ENVIRONMENT/g" /etc/sandstorm-agent/conf.d/*.conf

# Replaces SANDSTORM_IAM_ROLE_ARN with $SANDSTORM_IAM_ROLE_ARN environment variable
# need to use | here since roles contain "/"
sed -i "s|{SANDSTORM_IAM_ROLE_ARN}|${SANDSTORM_IAM_ROLE_ARN}|g" /etc/sandstorm-agent/templates.d/*
sed -i "s|{SANDSTORM_IAM_ROLE_ARN}|$SANDSTORM_IAM_ROLE_ARN|g" /etc/sandstorm-agent/conf.d/*.conf

echo "Setting Up Monit"

mkdir -p /var/lib/monit

monit
sleep 5
monit reload
sleep 5

echo "Restarting Sandstorm-Agent"

monit restart sandstorm-agent

# Clean Up
