# Hall Pass

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=cb-hallpass-build)](https://jenkins.internal.justin.tv/job/cb-hallpass-build) [![Go Report Card](https://goreportcard.internal.justin.tv/badge/code.justin.tv/cb/hallpass)](https://goreportcard.internal.justin.tv/report/code.justin.tv/cb/hallpass)

🐱 🍔 Permission Service - Ask nicely and you shall recieve

Hallpass manages channel permissions. Currently, this is only channel editors. You can list, create, delete, and check editors for a channel here.

## Development

### Installation

Run `make setup` to create a local, empty copy of the hallpass DB.

Hallpass uses redis to cache request results. If you wish, you can create and start a local redis cache. If you've never used redis before, maybe start [here](https://redis.io/documentation). Starting a local redis server is not required, and is really only necessary if you want to test out caching.

### Running

After installing, run `make dev-api` at the project root to start the hallpass api locally.

Running `make dev-worker` will start the hallpass worker environment. The worker exists solely to read messages published to the `hard_delete_user` sns topic, and delete the editors for the removed user. You can see more info on the sns topic [here](https://git-aws.internal.justin.tv/web/users-service/blob/master/doc/publishedEvents.md#events-published-to-sns).

Hallpass uses some default environment variables to configure things locally, which are as follows:

```
ENVIRONMENT ?= "dev"
REDIS_HOST ?= 127.0.0.1:6379
USERS_SERVICE_HOST ?= https://users-service.dev.us-west2.twitch.tv
STATSD_HOST ?= "graphite.internal.justin.tv:8125"
DB_HOST ?= localhost
DB_PORT ?= 5432
DB_NAME ?= hallpass
DB_SSLMODE ?= disable
```

If you want to change this configuration, you can do so in the makefile.

### Dependencies

Dependency management is done using glide. Add your dependency to the `glide.yaml` file, and then run `make update` to install it. 

### Testing

Mockery is used to generate testing mocks. You can run `make mocks` to generate mocks for packages in the `internal` directory. If for some reason you need to generate mocks for anything outside of that directory, can add change the `make mocks` command and add something like the following:

`mockery -all -dir=$INPUTDIR -case=underscore -output=$OUTPUTDIR`

## Documentation

API docs can be found on the Creator Business wiki page [here](https://wiki.twitch.com/display/CB/Hallpass+API)

## Environments

Hallpass staging: http://hallpass.staging.cb.internal.justin.tv

Hallpass production: http://hallpass.production.cb.internal.justin.tv

## Stats

Grafana: https://grafana.internal.justin.tv/dashboard/db/cb-hallpass
