-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied
CREATE TABLE IF NOT EXISTS editors(
    id serial PRIMARY KEY,
    channel_id integer NOT NULL,
    editor_user_id integer NOT NULL,
    created_on timestamp DEFAULT current_timestamp NOT NULL,
    updated_on timestamp,
    UNIQUE (channel_id, editor_user_id)
);

CREATE INDEX editors_channel_id_idx ON editors (channel_id);
CREATE INDEX editors_editor_user_id_idx ON editors (editor_user_id);
CREATE INDEX editors_channel_id_editor_user_id_idx ON editors (channel_id, editor_user_id);

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP TABLE IF EXISTS editors;