package api

import (
	"net/http"

	"goji.io/pat"

	"code.justin.tv/cb/hallpass/internal/httputil"
	"code.justin.tv/cb/hallpass/view"
)

func (s *Server) deleteV1Editor(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	channelID := pat.Param(req, "channel_id")
	editorID := pat.Param(req, "editor_id")

	_, err := s.validateUser(req.Context(), jsonWriter, channelID)
	if err != nil {
		return
	}

	_, err = s.validateUser(req.Context(), jsonWriter, editorID)
	if err != nil {
		return
	}

	err = s.dbWriter.DeleteEditor(req.Context(), channelID, editorID)
	if err != nil {
		jsonWriter.InternalServerError("failed to delete from editors table", err)
		return
	}

	s.redisClient.RemoveEditor(channelID, editorID)
	s.redisClient.RemoveEditable(editorID, channelID)

	response := view.DeleteEditorResponse{
		Status: "success",
	}

	jsonWriter.OK(response)
}
