package api

import (
	"net/http"

	"goji.io/pat"

	"code.justin.tv/cb/hallpass/internal/httputil"
	"code.justin.tv/cb/hallpass/view"
	log "github.com/sirupsen/logrus"
)

func (s *Server) getV1EditableChannels(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	channelID := pat.Param(req, "channel_id")

	// Check cache for existing channelID
	cachedEditable, err := s.redisClient.GetCachedEditable(channelID)
	if err != nil {
		log.WithError(err).Warn("failed to call editors cache")
	}

	if len(cachedEditable) > 0 {
		response := view.GetEditableChannelsResponse{
			Editable: cachedEditable,
		}

		jsonWriter.OK(response)
		return
	}

	editable, err := s.dbReader.GetEditableChannels(req.Context(), channelID)
	if err != nil {
		jsonWriter.InternalServerError("failed to query editors table", err)
		return
	}

	s.redisClient.CacheEditable(channelID, editable)

	response := view.GetEditableChannelsResponse{
		Editable: editable,
	}

	jsonWriter.OK(response)
}
