package api

import (
	"net/http"

	"goji.io/pat"

	"code.justin.tv/cb/hallpass/internal/httputil"
	"code.justin.tv/cb/hallpass/view"
	log "github.com/sirupsen/logrus"
)

func (s *Server) getV1IsEditor(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	channelID := pat.Param(req, "channel_id")
	editorID := pat.Param(req, "editor_id")

	cachedEditors, err := s.redisClient.GetCachedEditors(channelID)
	if err != nil {
		log.WithError(err).Warn("failed to call editors cache")
	}

	if len(cachedEditors) > 0 {
		isEditor := checkIfEditor(editorID, cachedEditors)
		response := view.GetIsEditorResponse{
			IsEditor: isEditor,
		}

		jsonWriter.OK(response)
		return
	}

	editors, err := s.dbReader.GetEditors(req.Context(), channelID)
	if err != nil {
		jsonWriter.InternalServerError("failed to query editors table", err)
		return
	}

	s.redisClient.CacheEditors(channelID, editors)
	isEditor := checkIfEditor(editorID, editors)

	response := view.GetIsEditorResponse{
		IsEditor: isEditor,
	}

	jsonWriter.OK(response)
}

func checkIfEditor(editorID string, channelEditors []string) bool {
	for _, editor := range channelEditors {
		if editor == editorID {
			return true
		}
	}

	return false
}
