package api

// PermissionsCache contains the basic methods needed for accessing the permissions cache.
// The cache has a simple structure: each key is a user id, and each value is a mapping
// of whether or not they are an editor, and who granted them the permission.
// In json it would look like this:
//
// channelID_Editors: {
//   editors: []
// }
//
// channelID_Editable: {
//  editable: []
// }
type PermissionsCache interface {
	GetCachedEditors(channelID string) ([]string, error)
	GetCachedEditable(channelID string) ([]string, error)

	CacheEditors(channelID string, editorIDs []string)
	CacheEditable(channelID string, editableIDs []string)

	RemoveEditor(channelID string, editorID string)
	RemoveEditable(channelID string, editableID string)
	RemoveAllEditors(channelID string)
	RemoveAllEditable(channelID string)
}
