package api

import "context"

// PermissionsDB contains the basic methods needed for accessing the permissions db.
type PermissionsDB interface {
	GetEditors(ctx context.Context, channelID string) ([]string, error)
	GetEditableChannels(ctx context.Context, channelID string) ([]string, error)
	CreateEditor(ctx context.Context, channelID string, editorUserID string) error
	DeleteEditor(ctx context.Context, channelID string, editorUserID string) error
	DeleteAllEditors(ctx context.Context, channelID string) error
}
