package cache

import (
	"github.com/go-redis/redis"
	log "github.com/sirupsen/logrus"
)

// RedisClient contains the redis cache connection information.
type RedisClient struct {
	cache *redis.Client
}

// RedisClientConfig contains the configuration for the redis cache client.
type RedisClientConfig struct {
	Addr     string
	Password string
	DB       int
}

// NewRedisClient opens a connection pool to the redis permissions cache.
func NewRedisClient(config RedisClientConfig) *RedisClient {
	cache := redis.NewClient(&redis.Options{
		Addr:     config.Addr,
		Password: config.Password,
		DB:       config.DB,
	})

	log.Infof(
		"cache: opened connection to redis to %s/%d",
		config.Addr,
		config.DB,
	)

	return &RedisClient{
		cache: cache,
	}
}
