package worker

import (
	"encoding/json"
	"net/http"
	"time"

	log "github.com/sirupsen/logrus"
)

type hardDeleteUserMessage struct {
	UserID    string    `json:"user_id" `
	Timestamp time.Time `json:"timestamp"`
}

func (s *Server) process(w http.ResponseWriter, req *http.Request) {
	if req.Body == nil {
		w.WriteHeader(http.StatusBadRequest)
		return
	}

	decoder := json.NewDecoder(req.Body)
	messageBody := &hardDeleteUserMessage{}
	err := decoder.Decode(messageBody)

	if err != nil {
		w.WriteHeader(http.StatusBadRequest)
		return
	}

	err = s.dbWriter.DeleteAllEditors(req.Context(), messageBody.UserID)
	if err != nil {
		log.WithError(err).Error("worker: failed to delete from editors table")

		w.WriteHeader(http.StatusInternalServerError)
		return
	}

	s.redisClient.RemoveAllEditors(messageBody.UserID)

	w.WriteHeader(http.StatusOK)
}
