// BUILD

multiJob('cb-hallpass-build') {
  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/hallpass', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  configure { project ->
    project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
  }

  publishers {
    githubCommitNotifier()
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    phase('Build') {
       phaseJob('cb-hallpass-build-api') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
      phaseJob('cb-hallpass-build-worker') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }
  }
}

freeStyleJob('cb-hallpass-build-api') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/hallpass', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_api.sh'
  }
}

freeStyleJob('cb-hallpass-build-worker') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/hallpass', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_worker.sh'
  }
}

// DEPLOY

multiJob('cb-hallpass-deploy') {
  parameters {
    stringParam 'ENVIRONMENT'
    stringParam 'BRANCH'
    stringParam 'GIT_COMMIT'
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  steps {
    phase('Deploy') {
      phaseJob('cb-hallpass-deploy-api') {
        killPhaseCondition('FAILURE')
      }
      phaseJob('cb-hallpass-deploy-worker') {
        killPhaseCondition('FAILURE')
      }
    }
  }
}

freeStyleJob('cb-hallpass-deploy-api') {
  using 'TEMPLATE-deploy-aws'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/hallpass', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_api.sh'
  }
}

freeStyleJob('cb-hallpass-deploy-worker') {
  using 'TEMPLATE-deploy-aws'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/hallpass', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_worker.sh'
  }
}
