resource "aws_db_subnet_group" "hallpass_db_subnet_group" {
  name        = "hallpass-db-subnet-${var.environment}"
  description = "Hallpass DB Subnet group"

  subnet_ids = [
    "${split(",", "${data.terraform_remote_state.account.private_subnets}")}",
  ]
}

resource "aws_db_instance" "master" {
  engine            = "postgres"
  engine_version    = "9.6.6"
  instance_class    = "${var.rds_instance_type}"
  storage_type      = "gp2"
  allocated_storage = "${var.rds_storage}"
  multi_az          = true

  identifier = "${var.team_code}-${var.name}-${var.environment}"
  name       = "${var.name}"
  username   = "master"
  password   = "temporary"

  publicly_accessible = false

  vpc_security_group_ids = [
    "${data.terraform_remote_state.account.twitch_subnets_sg}",
  ]

  port                 = 5432
  db_subnet_group_name = "${aws_db_subnet_group.hallpass_db_subnet_group.name}"
  monitoring_interval  = 5
  monitoring_role_arn  = "arn:aws:iam::989470033077:role/rds-monitoring-role"
  parameter_group_name = "pg-stat-statements-postgres-9-6"

  backup_retention_period = 1
  backup_window           = "02:00-04:00"

  tags {
    Environment = "${var.environment}"
    Name        = "${var.name}"
    Owner       = "${var.owner}"
    Project     = "${var.project}"
    Team        = "${var.team}"
  }
}

resource "aws_db_instance" "replica" {
  replicate_source_db = "${aws_db_instance.master.id}"

  instance_class    = "${var.rds_instance_type}"
  storage_type      = "gp2"
  allocated_storage = "${var.rds_storage}"

  identifier = "${aws_db_instance.master.id}-replica"
  name       = "${aws_db_instance.master.name}"

  publicly_accessible = false

  vpc_security_group_ids = [
    "${data.terraform_remote_state.account.twitch_subnets_sg}",
  ]

  port                 = "${aws_db_instance.master.port}"
  monitoring_interval  = 5
  monitoring_role_arn  = "arn:aws:iam::989470033077:role/rds-monitoring-role"
  parameter_group_name = "pg-stat-statements-postgres-9-6"

  tags {
    Environment = "${var.environment}"
    Name        = "${var.name}"
    Owner       = "${var.owner}"
    Project     = "${var.project}"
    Team        = "${var.team}"
  }
}
