resource "aws_cloudwatch_metric_alarm" "application_health" {
  alarm_name                = "${var.team_code}-${var.name}-${var.environment}-application-health"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "EnvironmentHealth"
  namespace                 = "AWS/ElasticBeanstalk"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "20"                                                                 # 20 is degraded health
  alarm_description         = "Monitors the health of this EBS application"
  insufficient_data_actions = []
  alarm_actions             = ["${aws_sns_topic.pagerduty_alerts.arn}"]
  ok_actions                = ["${aws_sns_topic.pagerduty_alerts.arn}"]

  dimensions {
    EnvironmentName = "${var.team_code}-${var.name}-${var.environment}-api"
  }
}
