terraform {
  required_version = ">= 0.10.6"

  backend "s3" {
    bucket  = "cb-hallpass-terraform"
    key     = "production/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

module "app" {
  source = "../modules/hallpass"

  environment             = "production"
  abbreviated_environment = "prd"

  instance_type = "c4.xlarge"
  asg_max_size  = 20
  asg_min_size  = 8

  hard_delete_user_arn = "arn:aws:sns:us-west-2:641044725657:notification-user-destroyed"
}

module "pagerduty_production" {
  source = "../modules/pagerduty"

  environment         = "production"
  pagerduty_alert_url = "https://events.pagerduty.com/integration/3679e8b731df4ec7aff93279f8de9694/enqueue"
}
