terraform {
  required_version = ">= 0.10.6"

  backend "s3" {
    bucket  = "cb-hallpass-terraform"
    key     = "staging/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

module "app" {
  source = "../modules/hallpass"

  environment             = "staging"
  abbreviated_environment = "stg"

  instance_type = "c4.large"
  asg_max_size  = 4
  asg_min_size  = 2

  hard_delete_user_arn = "arn:aws:sns:us-west-2:465369119046:notification-user-destroyed"
}
