# pubsub-go-pubclient

This is the official Go client for publishing messages into pubsub.

## Usage:
This example is adapted from our actual [presence application](https://git-aws.internal.justin.tv/chat/presence/blob/master/app/pubbroker/broker.go)
```Go
package presence

import (
	"encoding/json"
	"fmt"

	"github.com/cactus/go-statsd-client/statsd"
	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	pubclient "code.justin.tv/chat/pubsub-go-pubclient/client"
	"code.justin.tv/foundation/twitchclient"
)

// Publishes a user's presence state to a list of users (for this application, the user's friends)
func PublishPresence(ctx context.Context, stats statsd.Statter, p *Presence, userIDs []int64) error {
	if len(userIDs) == 0 {
		return nil
	}

	// Each friend listens on their own "presence" topic.
	topics := make([]string, 0, len(userIDs))
	for _, id := range userIDs {
		topics = append(topics, topic(id))
	}

	pubClient, err := pubclient.NewPubClient(twitchclient.ClientConf{
		Host:  "fake.pubsub.com",
		Stats: stats,
	})
	if err != nil {
		return errx.New(err)
	}

	// pubEntity is a struct which end clients will use to update the UX.
	marshalled, err := json.Marshal(pubEntity{
		Type: typePresence,
		Data: p,
	})
	if err != nil {
		return errx.New(err)
	}
	return pubClient.Publish(ctx, topics, string(marshalled), nil)
}

// Topic should be in the format "presence.<user ID>" because pubsub requires an
// OAuth token that resolves to the user ID in the second param.
func topic(userID int64) string {
	return fmt.Sprintf("presence.%d", userID)
}
```
