package config

import (
	"flag"
	"os"
	"testing"
)

func resetForTesting() {
	flag.CommandLine = flag.NewFlagSet(os.Args[0], flag.ContinueOnError)
	flag.Usage = nil
}

func TestCreateClients(t *testing.T) {
	resetForTesting()

	Register(map[string]string{
		"statsd-host-port": "thing_that_cant_be_dns_resolved:8125",
		"app":              "dns_test",
	})
	err := createClients()
	if err == nil {
		t.Fatalf("createClients should have returned error due to bad DNS, did not")
	}
}
