// +build go1.8

package pkgpath

import "testing"

func TestFindExecutableMainFile(t *testing.T) {
	if GoTestAggressiveTrimpath {
		t.Skip("test package names are hidden in Go 1.10+")
	}
	filename, err := findExecutableMainFile()
	if err != nil {
		t.Fatalf("findExecutableMainFile; err = %v", err)
	}
	pkg := fileImportPath(filename)
	if have, want := pkg, "code.justin.tv/common/golibs/pkgpath/_test"; have != want {
		t.Errorf("findExecutableMainFile(); %q != %q", have, want)
	}
}
