package pkgpath

import (
	"path"
	"testing"
)

func TestValidFilename(t *testing.T) {
	tests := []struct {
		file string
		ok   bool
	}{
		{file: "", ok: false},
		{file: "?", ok: false},
		{file: "<autogenerated>", ok: false},

		{file: "/tmp/script.go", ok: true},
		{file: "/go/src/code.justin.tv/my/project/main.go", ok: true},
		{file: "code.justin.tv/my/project/main.go", ok: true},
		{file: "main.go", ok: true},
		{file: "main.s", ok: true},
		{file: "main.c", ok: true},
	}

	for _, tt := range tests {
		if have, want := validFilename(tt.file), tt.ok; have != want {
			t.Errorf("validFilename(%q); %t != %t", tt.file, have, want)
		}
	}
}

func TestFileImportPath(t *testing.T) {
	tests := []struct {
		file string
		path string
	}{
		{file: "/go/src/code.justin.tv/web/tmi/irc/irc.go",
			path: "code.justin.tv/web/tmi/irc"},
		{file: "/go/src/code.justin.tv/web/owl/Godeps/_workspace/src/github.com/kisielk/errcheck/main.go",
			path: "github.com/kisielk/errcheck"},
		{file: "code.justin.tv/common/chitin/_test/generated.go",
			path: "code.justin.tv/common/chitin/_test"},
		{file: "/tmp/runme.go",
			path: ""},
	}

	for _, tt := range tests {
		if have, want := fileImportPath(tt.file), tt.path; have != want {
			t.Errorf("fileImportPath(%q); %q != %q", tt.file, have, want)
		}
	}
}

var testMainStackFilename, testMainStackErr = findMainInit()

func TestFindMainInit(t *testing.T) {
	filename := "code.justin.tv/common/golibs/pkgpath/_test/_testmain.go"
	if GoTestAggressiveTrimpath {
		filename = path.Base(filename)
	}

	if have, want := testMainStackFilename, filename; have != want {
		t.Errorf("findMainInit; %q != %q", have, want)
	}
	if err := testMainStackErr; err != nil {
		t.Errorf("findMainInit; err = %v", err)
	}
}
