// Code generated by protoc-gen-twirp v4.8.1, DO NOT EDIT.
// source: multiple2.proto

package multiple

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import bytes "bytes"
import context "golang.org/x/net/context"
import http "net/http"
import ioutil "io/ioutil"
import jsonpb "github.com/golang/protobuf/jsonpb"
import log "log"
import proto1 "github.com/golang/protobuf/proto"
import twirp "code.justin.tv/common/twirp"
import fmt1 "fmt"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ==============
// Svc2 Interface
// ==============

type Svc2 interface {
	Send(context.Context, *Msg2) (*Msg2, error)
}

// ====================
// Svc2 Protobuf Client
// ====================

type svc2ProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewSvc2ProtobufClient creates a Protobuf client that implements the Svc2 interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewSvc2ProtobufClient(addr string, client *http.Client) Svc2 {
	return &svc2ProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *svc2ProtobufClient) Send(ctx context.Context, in *Msg2) (*Msg2, error) {
	url := c.urlBase + Svc2PathPrefix + "Send"
	out := new(Msg2)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

// ================
// Svc2 JSON Client
// ================

type svc2JSONClient struct {
	urlBase string
	client  *http.Client
}

// NewSvc2JSONClient creates a JSON client that implements the Svc2 interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewSvc2JSONClient(addr string, client *http.Client) Svc2 {
	return &svc2JSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *svc2JSONClient) Send(ctx context.Context, in *Msg2) (*Msg2, error) {
	url := c.urlBase + Svc2PathPrefix + "Send"
	out := new(Msg2)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

// ===================
// Svc2 Server Handler
// ===================

type svc2Server struct {
	Svc2
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewSvc2Server(svc Svc2, hooks *twirp.ServerHooks, ctxSrc ContextSource) TwirpServer {
	defaultHooks := twirp.NewServerHooks()
	if hooks == nil {
		hooks = defaultHooks
	} else {
		if hooks.RequestReceived == nil {
			hooks.RequestReceived = defaultHooks.RequestReceived
		}
		if hooks.RequestRouted == nil {
			hooks.RequestRouted = defaultHooks.RequestRouted
		}
		if hooks.ResponsePrepared == nil {
			hooks.ResponsePrepared = defaultHooks.ResponsePrepared
		}
		if hooks.ResponseSent == nil {
			hooks.ResponseSent = defaultHooks.ResponseSent
		}
		if hooks.Error == nil {
			hooks.Error = defaultHooks.Error
		}
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}

	return &svc2Server{
		Svc2:      svc,
		hooks:     hooks,
		ctxSource: ctxSrc,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *svc2Server) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		writeErrorPreV3(ctx, resp, err, s.hooks)
	} else {
		writeErrorPostV3(ctx, resp, err, s.hooks)
	}
}

// Svc2PathPrefix is used for all URL paths on a twirp Svc2 server.
// Requests are always: POST Svc2PathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const Svc2PathPrefix = "/twirp/code.justin.tv.common.twirp.internal.twirptest.multiple.Svc2/"

// Svc2PathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const Svc2PathPrefixOld = "/v2/code.justin.tv.common.twirp.internal.twirptest.multiple.Svc2/"

func (s *svc2Server) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "Svc2")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt1.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}

	switch req.URL.Path {
	case Svc2PathPrefix + "Send", Svc2PathPrefixOld + "Send", "/v1/Svc2/Send":
		s.serveSend(ctx, resp, req)
		return
	default:
		msg := fmt1.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}
}

func (s *svc2Server) serveSend(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *svc2Server) serveSendJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "Send")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(Msg2)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Msg2
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Send(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Msg2 and nil error while calling Send. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *svc2Server) serveSendProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "Send")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(Msg2)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Msg2
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Send(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Msg2 and nil error while calling Send. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *svc2Server) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *svc2Server) ProtocGenTwirpVersion() string {
	return "v4.8.1"
}

var twirpFileDescriptor1 = []byte{
	// 135 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xe2, 0xcf, 0x2d, 0xcd, 0x29,
	0xc9, 0x2c, 0xc8, 0x49, 0x35, 0xd2, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0x32, 0x4f, 0xce, 0x4f,
	0x49, 0xd5, 0xcb, 0x2a, 0x2d, 0x2e, 0xc9, 0xcc, 0xd3, 0x2b, 0x29, 0xd3, 0x4b, 0xce, 0xcf, 0xcd,
	0xcd, 0xcf, 0xd3, 0x2b, 0x29, 0xcf, 0x2c, 0x2a, 0xd0, 0xcb, 0xcc, 0x2b, 0x49, 0x2d, 0xca, 0x4b,
	0xcc, 0x81, 0x70, 0x4b, 0x52, 0x8b, 0x4b, 0xf4, 0x60, 0xfa, 0x95, 0xd8, 0xb8, 0x58, 0x7c, 0x8b,
	0xd3, 0x8d, 0x8c, 0x7a, 0x19, 0xb9, 0x58, 0x82, 0xcb, 0x92, 0x8d, 0x84, 0x5a, 0x40, 0x8c, 0xd4,
	0xbc, 0x14, 0x21, 0x5b, 0x3d, 0x32, 0xcd, 0xd4, 0x03, 0x19, 0x28, 0x45, 0x99, 0x76, 0x27, 0xae,
	0x28, 0x0e, 0x98, 0x40, 0x12, 0x1b, 0xd8, 0x8f, 0xc6, 0x80, 0x00, 0x00, 0x00, 0xff, 0xff, 0x25,
	0x6d, 0x10, 0xf5, 0xf6, 0x00, 0x00, 0x00,
}
