package yimg_test

import (
	"testing"

	"code.justin.tv/common/yimg"
	"github.com/stretchr/testify/assert"
)

var channelOfflineImageInput = []byte(":sizes:\n- 640x360\n:ratio: 1.7777778\n:uid: 43c2de9e52bd3bf3\n:format: png\n")
var channelOfflineImageUser = "avalonstar"
var channelOfflineImageOutput = "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-channel_offline_image-43c2de9e52bd3bf3-640x360.png"

func TestChannelOfflineImages(t *testing.T) {
	got, err := yimg.ChannelOfflineImages(channelOfflineImageInput, channelOfflineImageUser)
	assert.NoError(t, err)

	if got["640x360"].URL != channelOfflineImageOutput {
		t.Errorf("have=%v;want=%v", got["640x360"].URL, channelOfflineImageOutput)
	}

	images, err := yimg.ChannelOfflineImagesToString(&got)
	assert.NoError(t, err)
	assert.Equal(t, *images, string(channelOfflineImageInput))
}
