package yimg_test

import (
	"testing"

	"code.justin.tv/common/yimg"
	"github.com/stretchr/testify/assert"
)

var profileBannerInput = []byte(":heights:\n- \"480\"\n:uid: 43c2de9e52bd3bf3\n:format: jpeg\n")
var profileBannerInputBySize = []byte(":sizes:\n- 640x480\n:uid: 43c2de9e52bd3bf3\n:format: jpeg\n")
var profileBannerUser = "avalonstar"
var profileBannerOutput = "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_banner-43c2de9e52bd3bf3-480.jpeg"
var profileBannerOutputBySize = "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_banner-43c2de9e52bd3bf3-640x480.jpeg"

func TestProfileBanners(t *testing.T) {
	got, err := yimg.ProfileBanners(profileBannerInput, profileBannerUser)
	assert.NoError(t, err)

	if got["480"].URL != profileBannerOutput {
		t.Errorf("have=%v;want=%v", got["480"].URL, profileBannerOutput)
	}

	images, err := yimg.ProfileBannersToString(&got)
	assert.NoError(t, err)
	assert.Equal(t, *images, string(profileBannerInput))
}

func TestProfileBannersWithSize(t *testing.T) {
	got, err := yimg.ProfileBanners(profileBannerInputBySize, profileBannerUser)
	assert.NoError(t, err)

	if got["480"].URL != profileBannerOutputBySize {
		t.Errorf("have=%v;want=%v", got["480"].URL, profileBannerOutputBySize)
	}

	images, err := yimg.ProfileBannersToString(&got)
	assert.NoError(t, err)
	assert.Equal(t, *images, string(profileBannerInputBySize))
}
