package yimg_test

import (
	"testing"

	"code.justin.tv/common/yimg"
	"github.com/stretchr/testify/assert"
)

var profileImageInput = []byte(":sizes:\n- 300x300\n- 150x150\n- 96x96\n- 70x70\n- 50x50\n- 28x28\n- 600x600\n:ratio: 1\n:uid: 43c2de9e52bd3bf3\n:format: jpeg\n")
var profileImageUser = "avalonstar"
var profileImageOutput = []string{"https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_image-43c2de9e52bd3bf3-300x300.jpeg", "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_image-43c2de9e52bd3bf3-150x150.jpeg", "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_image-43c2de9e52bd3bf3-96x96.jpeg", "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_image-43c2de9e52bd3bf3-70x70.jpeg", "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_image-43c2de9e52bd3bf3-50x50.jpeg", "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_image-43c2de9e52bd3bf3-28x28.jpeg", "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_image-43c2de9e52bd3bf3-600x600.jpeg"}

func TestProfileImages(t *testing.T) {
	outputMap := map[string]string{
		"300x300": profileImageOutput[0],
		"150x150": profileImageOutput[1],
		"96x96":   profileImageOutput[2],
		"70x70":   profileImageOutput[3],
		"50x50":   profileImageOutput[4],
		"28x28":   profileImageOutput[5],
		"600x600": profileImageOutput[6],
	}

	got, err := yimg.ProfileImages(profileImageInput, profileImageUser)
	assert.NoError(t, err)

	for key := range got {
		if got[key].URL != outputMap[key] {
			t.Errorf("have=%v;want=%v", got[key].URL, profileImageOutput)
		}
	}

	images, err := yimg.ProfileImagesToString(&got)
	assert.NoError(t, err)

	input := []byte(*images)
	got, err = yimg.ProfileImages(input, profileImageUser)
	assert.NoError(t, err)

	got, err = yimg.ProfileImages(profileImageInput, profileImageUser)
	assert.NoError(t, err)

	for key := range got {
		if got[key].URL != outputMap[key] {
			t.Errorf("have=%v;want=%v", got[key].URL, profileImageOutput)
		}
	}
}
