// +build integration

package fanout

import (
	"testing"

	"code.justin.tv/feeds/feeds-common/entity"
	"code.justin.tv/feeds/feeds-common/verb"
	"code.justin.tv/feeds/service-common"
	"github.com/aws/aws-sdk-go/service/sqs"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestIntegrationFanoutClient(t *testing.T) {
	Convey("With a client", t, func() {
		s := service_common.ConfigCommon{
			Team:          "feeds",
			Service:       "int_tests",
			BaseDirectory: "../",
		}
		So(s.Setup(), ShouldBeNil)
		fconf := &Config{}
		So(fconf.Load(s.Config), ShouldBeNil)

		session, awsConf := service_common.CreateAWSSession(s.Config)
		sqsClient := sqs.New(session, awsConf...)

		lqi := sqs.ListQueuesInput{}
		lqOut, err := sqsClient.ListQueues(&lqi)
		So(err, ShouldBeNil)
		So(len(lqOut.QueueUrls), ShouldBeGreaterThan, 0)

		c := Client{
			Config: fconf,
			Sqs:    sqsClient,
		}
		ctx := context.Background()
		Convey("Should be able to send a single activity", func() {
			So(c.AddActivity(ctx, &Activity{
				Entity: entity.New("test", "1"),
				Verb:   verb.Create,
				Actor:  entity.New(entity.NamespaceUser, "1"),
			}), ShouldBeNil)
		})
		Convey("Should be able to send many activities", func() {
			So(c.AddActivities(ctx, []*Activity{
				{
					Entity: entity.New("test", "1"),
					Verb:   verb.Create,
					Actor:  entity.New(entity.NamespaceUser, "1"),
				},
			}), ShouldBeNil)
		})
	})
}
