package feeddataflow

import (
	"testing"
	"time"

	"code.justin.tv/feeds/feeds-common/entity"
	. "github.com/smartystreets/goconvey/convey"
)

func TestValidateEntity(t *testing.T) {
	Convey("Can merge metadata", t, func() {
		m := Metadata{}
		t1 := time.Now().Add(-time.Second)
		t2 := time.Now()
		e1 := entity.New("test", "1")
		e2 := entity.New("test", "2")
		m.SetEntityCreationTime(e1, t1, t2)
		_, _, exists := m.GetEntityCreationTime(e2)
		So(exists, ShouldBeFalse)
		a, b, exists := m.GetEntityCreationTime(e1)
		So(exists, ShouldBeTrue)
		So(a.UnixNano(), ShouldEqual, t1.UnixNano())
		So(b.UnixNano(), ShouldEqual, t2.UnixNano())
		So(a.UnixNano(), ShouldNotEqual, b.UnixNano())

		m2 := Metadata{}
		e3 := entity.New("test", "3")
		m.SetEntityCreationTime(e3, t1, t2)

		m2.MergeFrom(nil)
		m2.MergeFrom(&m)
		a, b, exists = m.GetEntityCreationTime(e1)
		So(exists, ShouldBeTrue)
		So(a.UnixNano(), ShouldEqual, t1.UnixNano())
		So(b.UnixNano(), ShouldEqual, t2.UnixNano())
		So(a.UnixNano(), ShouldNotEqual, b.UnixNano())

		a, b, exists = m.GetEntityCreationTime(e3)
		So(exists, ShouldBeTrue)
		So(a.UnixNano(), ShouldEqual, t1.UnixNano())
		So(b.UnixNano(), ShouldEqual, t2.UnixNano())
		So(a.UnixNano(), ShouldNotEqual, b.UnixNano())
		Convey("and bool metadata", func() {
			_, _, exists := m.GetIsDeleted(e1)
			So(exists, ShouldBeFalse)
			validAtOriginal := time.Now()
			m.SetIsDeleted(e1, true, validAtOriginal)
			a, origTime, exists := m.GetIsDeleted(e1)
			So(exists, ShouldBeTrue)
			So(a, ShouldBeTrue)
			So(origTime.UnixNano(), ShouldEqual, validAtOriginal.UnixNano())

			m2 := Metadata{}
			m2.MergeFrom(&m)
			a, origTime, exists = m2.GetIsDeleted(e1)
			So(exists, ShouldBeTrue)
			So(a, ShouldBeTrue)
			So(origTime.Unix(), ShouldEqual, validAtOriginal.Unix())

		})
		Convey("and follow metadata", func() {
			_, _, exists := m.GetFollow("user1", "user2")
			So(exists, ShouldBeFalse)
			validAtOriginal := time.Now()
			m.SetFollow("user1", "user2", true, validAtOriginal)
			follows, _, exists := m.GetFollow("user1", "user2")
			So(exists, ShouldBeTrue)
			So(follows, ShouldBeTrue)

			m2 := Metadata{}
			m2.MergeFrom(&m)
			follows, validAt, exists := m2.GetFollow("user1", "user2")
			So(exists, ShouldBeTrue)
			So(follows, ShouldBeTrue)
			So(validAt.Unix(), ShouldEqual, validAtOriginal.Unix())

			_, _, exists = m2.GetFollow("user1", "user3")
			So(exists, ShouldBeFalse)
		})
	})
}
