freeStyleJob('feeds-clients') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'feeds/clients', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'manta -v -f build.json'
    saveDeployArtifact 'feeds/clients', '.manta'
  }
}

freeStyleJob('feeds-clients-deploy') {
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo feeds/clients --dir /opt/twitch/clients'
  }
}
