package ctxlogsqs

import (
	"context"

	"code.justin.tv/feeds/ctxlog"
	"github.com/aws/aws-sdk-go/service/sqs"
	"github.com/aws/aws-sdk-go/aws"
	"strconv"
)

func ModifyRequest(ctx context.Context, inputMap map[string]*sqs.MessageAttributeValue, ch *ctxlog.Ctxlog) map[string]*sqs.MessageAttributeValue {
	if ch == nil {
		return inputMap
	}
	ret := make(map[string]*sqs.MessageAttributeValue, len(inputMap) + 2)
	for k, v := range inputMap {
		ret[k] = v
	}

	currentDebugID, isElevated := ch.ExtractDebugInfo(ctx)
	if currentDebugID == "" {
		currentDebugID = ch.NewDebugID()
	}
	ret[ch.GetLogIDHeader()] = &sqs.MessageAttributeValue{
		StringValue: &currentDebugID,
		DataType: aws.String("String"),
	}
	if isElevated {
		ret[ch.GetElevateLogHeader()] = &sqs.MessageAttributeValue{
			StringValue: aws.String("true"),
			DataType: aws.String("String"),
		}
	}
	return ret
}

func ExtractContext(ctx context.Context, input map[string]*sqs.MessageAttributeValue, ch *ctxlog.Ctxlog) context.Context {
	if len(input) == 0 {
		return ch.CtxDims.Append(ctx, ch.GetLogIDHeader(), ch.NewDebugID())
	}
	var currentDebugID string
	currentDebugIDattr, exists := input[ch.GetLogIDHeader()]
	if exists && currentDebugIDattr.StringValue != nil {
		currentDebugID = *currentDebugIDattr.StringValue
	}
	if currentDebugID == "" {
		currentDebugID = ch.NewDebugID()
	}
	ctx = ch.CtxDims.Append(ctx, ch.GetLogIDHeader(), currentDebugID)
	var isElevated bool
	currentElevatedAttr, exists := input[ch.GetElevateLogHeader()]
	if exists && currentElevatedAttr.StringValue != nil {
		// We accept the error parse as a false is elevated
		isElevated, _ = strconv.ParseBool(*currentElevatedAttr.StringValue)
	}
	if isElevated {
		ctx = context.WithValue(ctx, ch.ElevateKey, true)
	}
	return ctx
}