package log

import (
	"bytes"
	"errors"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

type panicError struct{}

func (p *panicError) Error() string {
	panic("failure?")
}

type unjsonable struct{}

var errNope = errors.New("nope")

func (u unjsonable) MarshalJSON() ([]byte, error) {
	return nil, errNope
}

func TestJSONLoggerInternal(t *testing.T) {
	Convey("JSON logger to a buffer", t, func() {
		b := &bytes.Buffer{}
		l := NewJSONLogger(b, Panic)
		Convey("should convert non string keys", func() {
			l.Log(5678, 1234)
			So(b.String(), ShouldContainSubstring, "1234")
			So(b.String(), ShouldContainSubstring, "5678")
		})
		Convey("should throw normal panics", func() {
			So(func() {
				l.Log("err", &panicError{})
			}, ShouldPanicWith, "failure?")

		})
	})
}
