package multistatsd

import (
	"time"

	"github.com/cactus/go-statsd-client/statsd"
)

type MultiStatSender struct {
	StatSenders []statsd.StatSender
}

var _ statsd.StatSender = &MultiStatSender{}

func (m *MultiStatSender) Inc(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Inc(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

func (m *MultiStatSender) Dec(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Dec(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

func (m *MultiStatSender) Gauge(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Gauge(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

func (m *MultiStatSender) GaugeDelta(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.GaugeDelta(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

func (m *MultiStatSender) Timing(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Timing(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

func (m *MultiStatSender) TimingDuration(s string, v time.Duration, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.TimingDuration(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

func (m *MultiStatSender) Set(s string, v string, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Set(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

func (m *MultiStatSender) SetInt(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.SetInt(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

func (m *MultiStatSender) Raw(s string, v string, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Raw(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

type MultiSubStatter struct {
	MultiStatSender
}

var _ statsd.SubStatter = &MultiSubStatter{}

func (m *MultiSubStatter) SetSamplerFunc(f statsd.SamplerFunc) {
	for _, s := range m.StatSenders {
		s.(statsd.SubStatter).SetSamplerFunc(f)
	}
}

func (m *MultiSubStatter) NewSubStatter(prefix string) statsd.SubStatter {
	ret := &MultiSubStatter{}
	for _, s := range m.StatSenders {
		ret.StatSenders = append(ret.StatSenders, s.(statsd.SubStatter).NewSubStatter(prefix))
	}
	return ret
}

// MultiStatter can proxy a sent statsd metrics to multiple statsd endpoints
type MultiStatter struct {
	MultiStatSender
}

var _ statsd.Statter = &MultiStatter{}

func (m *MultiStatter) NewSubStatter(p string) statsd.SubStatter {
	ret := &MultiSubStatter{}
	for _, s := range m.StatSenders {
		ret.StatSenders = append(ret.StatSenders, s.(statsd.Statter).NewSubStatter(p))
	}
	return ret
}

func (m *MultiStatter) SetPrefix(p string) {
	for _, s := range m.StatSenders {
		s.(statsd.Statter).SetPrefix(p)
	}
}

func (m *MultiStatter) Close() error {
	var ret error
	for _, s := range m.StatSenders {
		if err := s.(statsd.Statter).Close(); err != nil {
			ret = err
		}
	}
	return ret
}
