// +build integration

package gorediscache_test

import (
	"testing"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/service-common"
	"code.justin.tv/feeds/service-common/feedcache"
	"code.justin.tv/feeds/service-common/feedcache/gorediscache"
	"github.com/go-redis/redis"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

type testConfig struct {
	gorediscache.GoredisConfig
}

func (t *testConfig) Load(dconf *distconf.Distconf) error {
	return t.Verify("inttest", dconf)
}

func TestRedisIntegration(t *testing.T) {
	s := service_common.ConfigCommon{
		Team:          "feeds",
		Service:       "int_tests",
		BaseDirectory: "../../../fanout/",
	}
	err := s.Setup()
	if err != nil {
		t.Error("Unable to set up config")
		return
	}
	var rconf testConfig
	err = rconf.Load(s.Config)
	if err != nil {
		t.Error("Unable to load config")
		return
	}
	opts := &redis.ClusterOptions{
		Addrs: []string{s.Config.Str("testing.redis.address", "").Get()},
	}
	clusterClient := redis.NewClusterClient(opts)

	rcache := gorediscache.NewGoredisCache(clusterClient, &rconf.GoredisConfig, "intest:", nil, service_common.NopStatSender())

	Convey("With a redis integration", t, func() {
		ctx := context.Background()
		feedcache.CommonCacheTestingHelper(ctx, t, rcache)
	})
}
