package spadetest

import (
	"testing"
	"context"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/spade"
	"code.justin.tv/feeds/spade/spadedconf"
	. "github.com/smartystreets/goconvey/convey"
)

type testEvent struct {
	Name string
}

func TestSpadeServer(t *testing.T) {
	Convey("With setup", t, func() {
		t := TestingSpadeServer{}
		finishedServing := make(chan struct{})
		go func() {
			t.Start()
			close(finishedServing)
		}()
		var mem distconf.InMemory
		t.SetupDistconf(&mem)
		dconf := &distconf.Distconf{
			Readers: []distconf.Reader{&mem},
		}
		conf := &spadedconf.Config{}
		So(conf.Load(dconf), ShouldBeNil)
		c := spade.Client{
			Config: conf,
		}
		c.Setup()
		go func() {
			c.Start()
		}()
		ctx := context.Background()
		So(c.VerifyEndpoint(ctx), ShouldBeNil)

		event := spade.Event{
			Name: "testing_events",
			Properties: testEvent{
				Name: "testing-code",
			},
		}
		err := c.BlockingSendEvents(ctx, event)
		So(err, ShouldBeNil)
		res := <-t.Events
		So(res.Name, ShouldEqual, "testing_events")

		event.Name = "queue_event"
		c.QueueEvents(event)

		res = <-t.Events
		So(res.Name, ShouldEqual, "queue_event")

		So(t.Close(), ShouldBeNil)
		<-finishedServing
		So(c.Close(), ShouldBeNil)
	})
}
