// +build integration

package xray

import (
	"context"
	"sync"
	"testing"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func TestXRay(t *testing.T) {
	x := XRay{}
	l := sync.WaitGroup{}
	l.Add(2)
	ctx := context.Background()
	go x.Capture(ctx, "TestXRay", func(ctx context.Context) error {
		time.Sleep(time.Second)
		l.Done()
		return nil
	})
	go x.Capture(ctx, "TestXRay", func(ctx context.Context) error {
		time.Sleep(time.Second)
		l.Done()
		return nil
	})
	l.Wait()
}

func TestDynamoDBClient(t *testing.T) {
	clientProvider, err := session.NewSession(&aws.Config{Region: aws.String("us-west-2")})
	if err != nil {
		t.Error("invalid session", err)
	}
	dbClient := dynamodb.New(clientProvider)
	x := XRay{}
	x.AWS(dbClient.Client)
	_, err = dbClient.ListTables(nil)
	if err != nil {
		t.Error("invalid list tables", err)
	}
}
