package twitchclient_test

import (
	"fmt"
	"log"
	"strconv"

	"context"

	"code.justin.tv/foundation/twitchclient"
)

type MyClient struct {
	twitchclient.Client
}

func Example_client() {
	c, err := twitchclient.NewClient(twitchclient.ClientConf{
		Host: "example.com",
	})
	if err != nil {
		log.Fatal(err)
	}

	client := &MyClient{c}
	_, _ = client.DoThing(context.Background())
}

type Thing struct {
	Foo string `json:"foo"`
	Bar int    `json:"-"`
}

func (c *MyClient) DoThing(ctx context.Context) (*Thing, error) {
	req, err := c.NewRequest("GET", "/", nil)
	if err != nil {
		return nil, err
	}

	data := &Thing{}
	resp, err := c.DoJSON(ctx, data, req, twitchclient.ReqOpts{
		StatName: "some_request",
	})
	if err != nil {
		return nil, err
	}

	data.Bar, err = strconv.Atoi(resp.Header.Get("bar"))
	if err != nil {
		return nil, fmt.Errorf("Invalid value for header \"bar\": %s", err)
	}

	return data, nil
}
