// +build integration

package sandyconf_test

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"testing"
	"time"

	"code.justin.tv/hygienic/sandyconf"

	. "github.com/smartystreets/goconvey/convey"
)

type config struct {
	Team        string
	Service     string
	Environment string

	Key         string
	EndingValue string

	RoleARN string
}

func TestIntegrationSandyconf(t *testing.T) {
	// Note: Will only work if you have ARN permissions in .json file
	Convey("With config", t, func() {
		content, err := ioutil.ReadFile(".sandy_integration.json")
		So(err, ShouldBeNil)
		var c config
		So(json.Unmarshal(content, &c), ShouldBeNil)
		mc := sandyconf.ManagerConstructor{}
		mgr := mc.Manager(c.RoleARN)
		s := sandyconf.Sandyconf{
			Team:        c.Team,
			Service:     c.Service,
			Environment: c.Environment,
			Manager:     mgr,
		}
		ret, err := s.Get(c.Key)
		So(err, ShouldBeNil)
		So(string(ret), ShouldEqual, c.EndingValue)

		So(s.Watch(c.Key, func(key string) {
			newVal, err := s.Get(key)
			So(err, ShouldBeNil)
			So(newVal, ShouldNotEqual, c.EndingValue)
			t.Logf("Update on key %s is now %s", key, newVal)
		}), ShouldBeNil)

		for i := 0; i < 30; i++ {
			fmt.Printf("On sleep %d\n", i)
			t.Logf("On sleep %d", i)
			time.Sleep(time.Second)
			s.Refresh()
		}
	})
}
