package amzncorp

import "crypto/x509"

func InternalCerts() *x509.CertPool {
	pool := x509.NewCertPool()
	appendInternalCerts(pool)
	return pool
}

func AllCerts() (*x509.CertPool, error) {
	pool, err := x509.SystemCertPool()
	if err != nil {
		return nil, err
	}
	appendInternalCerts(pool)
	return pool, nil
}

func appendInternalCerts(pool *x509.CertPool) {
	for _, pem := range internalCertPEMs {
		pool.AppendCertsFromPEM(pem)
	}
}

// https://w.amazon.com/index.php/Infosec/Internally%20Signed%20Certificates
var internalCertPEMs = [][]byte{
	// Amazon.com Internal Root Certificate Authority
	[]byte(`-----BEGIN CERTIFICATE-----
MIIEDzCCAvegAwIBAgIQV4cU8I3h2atKJXrl167+ITANBgkqhkiG9w0BAQUFADA5
MTcwNQYDVQQDEy5BbWF6b24uY29tIEludGVybmFsIFJvb3QgQ2VydGlmaWNhdGUg
QXV0aG9yaXR5MB4XDTA3MDgzMDE4MDIyNVoXDTI3MDgzMDE4MTA1OVowOTE3MDUG
A1UEAxMuQW1hem9uLmNvbSBJbnRlcm5hbCBSb290IENlcnRpZmljYXRlIEF1dGhv
cml0eTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAO6Bh0acNqMWBRt+
vp6TcA+dKLLqcdRZQRu/Eo8Vzh6JZpZwYGB7glOJqbFWZm7fIWHzqSUUZgHGLHAn
fbOgPno19aW5uG/Z94xAXHEoo6Ird1lIgMtsaoIy8gsNb+FgcsYvr+sUMU9htJuz
uYkvEUGZZ3IIW9+kMUQwNw9U4U3DgQRAvtOCY+fmWha+2CRIC57kQiCkRwrDLzrK
Wm/Or86P8YRaoPyxcBSeFYuBKbqvWOwAqWTW2ZoqxpYGMwLh+JKDxmrUkj8JD4Vy
RnmceSIIHO3NYRinWbu4FAEFxn/6Xap3P3e7/t8PGbIgIgTh6cavnFNZK/0wM3BB
B31guH0CAwEAAaOCAREwggENMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
MB0GA1UdDgQWBBR/jbFOTKKYCtyLJ79iBWk8JRKzwjAQBgkrBgEEAYI3FQEEAwIB
ADCBuwYDVR0gBIGzMIGwMIGtBgwrBgEEAaVrgUgBAQEwgZwwcgYIKwYBBQUHAgIw
Zh5kAEEAbQBhAHoAbwBuAC4AYwBvAG0AIABJAG4AdABlAHIAbgBhAGwAIABDAGUA
cgB0AGkAZgBpAGMAYQB0AGUAIABQAHIAYQBjAHQAaQBjAGUAIABTAHQAYQB0AGUA
bQBlAG4AdDAmBggrBgEFBQcCARYaaHR0cDovL3BraS5hbWF6b24uY29tL2Nwcy8w
DQYJKoZIhvcNAQEFBQADggEBAHQBbp49lpDzeZwT0S125zVpKnie8tSgnY0AjW/h
QMHcDSIGCA2j1d8Sx+Kf+0mheRa4fG0Hm5xk0BbdmV61dB9bcMBtZWvmQBlO/iH+
7/06oBVkI67FgxRmp/AmI/JubjGP12eWXoX2YXtSvkjsP49f4ya4k2wTNrcypwlr
Fx5+sjnRdOf24IyDGjr/HnoupYPjoDGtgF7hiMXwVD1UFHPhLVxLQojuYDjSLl3I
5zaeacRPp76IhA8YfNCJO56t4JGEbJsuQqLfIKF7hTDoqpDipJVUBh/WcmOsNiTd
FQccX3klxYIfJOHixp9MdxMRM1bHwX0xZaUX3qBngHz85GU=
-----END CERTIFICATE-----`),

	// Amazon Corporate Systems Certificate Authority G2 01
	[]byte(`-----BEGIN CERTIFICATE-----
MIIEqTCCA5GgAwIBAgIKYQbuWgAAAAAAETANBgkqhkiG9w0BAQUFADA5MTcwNQYD
VQQDEy5BbWF6b24uY29tIEludGVybmFsIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
aXR5MB4XDTEzMDkyMDIyMjkyM1oXDTE4MDkyMDIyMzkyM1owgYExEzARBgoJkiaJ
k/IsZAEZFgNjb20xFjAUBgoJkiaJk/IsZAEZFgZhbWF6b24xEzARBgoJkiaJk/Is
ZAEZFgNhbnQxPTA7BgNVBAMTNEFtYXpvbiBDb3Jwb3JhdGUgU3lzdGVtcyBDZXJ0
aWZpY2F0ZSBBdXRob3JpdHkgRzIgMDEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
ggEKAoIBAQDIQqcGShRsy1JplDN1q+b9jSO/CCbXvWI1pIn5VkYU6gUpKss7GVkj
DDFiYrWynLgTQzy7akfdbwxus1lycW3FWiHVBr1pc+vVs8oOdbM0j9UVnvwAi50u
UKOBBCeVGweOHwA/qQLagNWiMgdXUspt8uPhDTXNaYc0XMrdMbK4fX3Qzevruwls
Fdu/F/S2nJ1TUs/pYy/LpM2b3AGfSSTOuGECKObXU0wTJhx1WI0w+f9tXLtRNw92
nUKrRdgKXITL4HNoEZVgwaQaglj7s36f0x8sM4qL4LZ+WwowTWmKe2A8aX8d9JlI
GNDbI65KVTv8XuP/9yaWoHWT1J7xmwyVAgMBAAGjggFoMIIBZDAQBgkrBgEEAYI3
FQEEAwIBADAdBgNVHQ4EFgQU2HPRHn28H1419vTCFDcPTayeGC0wGQYJKwYBBAGC
NxQCBAweCgBTAHUAYgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8w
HwYDVR0jBBgwFoAUf42xTkyimArciye/YgVpPCUSs8IwZQYDVR0fBF4wXDBaoFig
VoZUaHR0cDovL3BraS5hbWF6b24uY29tL2NybC9BbWF6b24uY29tJTIwSW50ZXJu
YWwlMjBSb290JTIwQ2VydGlmaWNhdGUlMjBBdXRob3JpdHkuY3JsMHAGCCsGAQUF
BwEBBGQwYjBgBggrBgEFBQcwAoZUaHR0cDovL3BraS5hbWF6b24uY29tL2NydC9B
bWF6b24uY29tJTIwSW50ZXJuYWwlMjBSb290JTIwQ2VydGlmaWNhdGUlMjBBdXRo
b3JpdHkuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBThHm2RAseuhH/PMP7iO2G8f/K
SD01JgB4gVMuEPShYiopqcmFxWSbzNd8okqZI8+Lm/JucYRr9UWPCqmZwpSoSQ0s
2ukPhXvoVwlATpXSflp3BZEz8YHtpcPgmKNhDzpgvMpiidJoNha5G/ayZcCF7fWJ
xPUsLe7MNlwSQgxokFz6SLUQ/tRKaY2YiUNf7QPcPuDr5Aj0sI8uTjbXgIPnDOm5
WPU8HRgQ5w5/cxEcmtCoxq3hEobJpC1wHs18DIvxdZK/pmUKzE3g/jnBQYk3+IoW
WzQjndEazF8pXw6iB20hTs4+oqsTI1Q9egmTLvweTT3SXzISmozddZLDHTwp
-----END CERTIFICATE-----`),

	// Amazon Corporate Systems Certificate Authority G2 02
	[]byte(`-----BEGIN CERTIFICATE-----
MIIEqTCCA5GgAwIBAgIKYQ0C7gAAAAAAEjANBgkqhkiG9w0BAQUFADA5MTcwNQYD
VQQDEy5BbWF6b24uY29tIEludGVybmFsIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
aXR5MB4XDTEzMTAwOTIwMTYzMFoXDTE4MTAwOTIwMjYzMFowgYExEzARBgoJkiaJ
k/IsZAEZFgNjb20xFjAUBgoJkiaJk/IsZAEZFgZhbWF6b24xEzARBgoJkiaJk/Is
ZAEZFgNhbnQxPTA7BgNVBAMTNEFtYXpvbiBDb3Jwb3JhdGUgU3lzdGVtcyBDZXJ0
aWZpY2F0ZSBBdXRob3JpdHkgRzIgMDIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
ggEKAoIBAQDb5iEfjecFgQCgW/6ODzOxlw6TO0NsMjBRY84EaIukZlfC34PpOef6
QW1Z0vwmomMqLmRoK43onEIwXo/fLl/pFA6ux4bkV9K4fYpRa/M/F8Q4+iUuGV8u
rUFOabYKLytyBZHCSxn5RVV+xkQ1ajHPJ8EElL6WFnT1hb9Ol7isWVgYZvmIRuY+
sxsXmIvtqp23Ka+Npc/3ZBbY8t4MQ9qb/fbAs/aFVRCQWMRuEEHY5jRj/1tj8Hig
6wG33WXBfUg+kzIC3iXzOspyjI4QA5Gs73m9z1CdokZbb6DQLlgtEb91rIyg7WWF
ui0HNbBtDbqMBBNrK10WqF5puzXeYt+5AgMBAAGjggFoMIIBZDAQBgkrBgEEAYI3
FQEEAwIBADAdBgNVHQ4EFgQUbtdGWZfJmzIGZMlI3FfGO6iRP5YwGQYJKwYBBAGC
NxQCBAweCgBTAHUAYgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8w
HwYDVR0jBBgwFoAUf42xTkyimArciye/YgVpPCUSs8IwZQYDVR0fBF4wXDBaoFig
VoZUaHR0cDovL3BraS5hbWF6b24uY29tL2NybC9BbWF6b24uY29tJTIwSW50ZXJu
YWwlMjBSb290JTIwQ2VydGlmaWNhdGUlMjBBdXRob3JpdHkuY3JsMHAGCCsGAQUF
BwEBBGQwYjBgBggrBgEFBQcwAoZUaHR0cDovL3BraS5hbWF6b24uY29tL2NydC9B
bWF6b24uY29tJTIwSW50ZXJuYWwlMjBSb290JTIwQ2VydGlmaWNhdGUlMjBBdXRo
b3JpdHkuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBuqh2As/wqH/X0AkEsGZuGN/3Y
rHxMqm/MhPxAl0pK2V+bQVEp43VCF8ZIQIvT8/Wm+59ExzoripCLA+6Yr6QSwlb3
NNPrgnVrKSqaDRdhY1WXoSwtRByH2zZIVf692mFkdUfu71Bx5MGSx5aMT0Pl/tCL
DArqNDPFf2W/CIkUVhdvq3mRKMdnIh4VYpShLFVbG1oaEcWdkP38T7hxkRTahsiM
HFmSLn9bRYWRa8r2iqHtWGbskd3H5o9xKkQDJlLXiaDFi6+10T78SMEZ9lHdIJR8
TisGKbRDpaJQy2p+T0HDjWIiYbFpz/fCCQIOjJ6s1zEZ/zMOawONTPv/XyBm
-----END CERTIFICATE-----`),

	// Amazon.com InfoSec CA G3
	[]byte(`-----BEGIN CERTIFICATE-----
MIIEszCCA5ugAwIBAgIKYSUegAAAAAAAHDANBgkqhkiG9w0BAQsFADA5MTcwNQYD
VQQDEy5BbWF6b24uY29tIEludGVybmFsIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
aXR5MB4XDTE1MDIxMzIyMTQzNVoXDTIwMDIxMzIyMjQzNVowZTETMBEGCgmSJomT
8ixkARkWA2NvbTEWMBQGCgmSJomT8ixkARkWBmFtYXpvbjETMBEGCgmSJomT8ixk
ARkWA2FudDEhMB8GA1UEAxMYQW1hem9uLmNvbSBJbmZvU2VjIENBIEczMIIBIjAN
BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAt3duk+0zdYmZXuuB1JjWtFnuN6d9
dXM3GaWmGCeAfi6u9A1z0rqnDJjwXkAIGMA99kzMzFC6fOpRk0bvdWM4VykgHmhU
bJ7PyRS9EtNDIhLqLGag65xGkUMDLqkQYfJqg/C58iYF4s0z6r6XTTvAuc8zuMFm
xxJpDdZqw3bspdTzZ70+8ZZCQJUvVL05KrM3n9mwNa1+8k13U7m6ZNgvydIgqaDU
/cC6CKvtQw0uWcRoRSZHglHIq4gLlT6JM4xWi/OnSUxawhE0t++JsvN2wSU+pQEF
mJTX6sM35OrJOWT1+F1B+k1B3GjtnRLxsTDM4rOXeebCUveMyJGFVDFa0wIDAQAB
o4IBjzCCAYswEgYJKwYBBAGCNxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQUQJMa
85RU9cQxCLoZPo3aih1LRUgwHQYDVR0OBBYEFIJaaahJnWTLFDazYVuTcafwEcgM
MBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIAQwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMB
Af8EBTADAQH/MB8GA1UdIwQYMBaAFH+NsU5MopgK3Isnv2IFaTwlErPCMGUGA1Ud
HwReMFwwWqBYoFaGVGh0dHA6Ly9wa2kuYW1hem9uLmNvbS9jcmwvQW1hem9uLmNv
bSUyMEludGVybmFsJTIwUm9vdCUyMENlcnRpZmljYXRlJTIwQXV0aG9yaXR5LmNy
bDBwBggrBgEFBQcBAQRkMGIwYAYIKwYBBQUHMAKGVGh0dHA6Ly9wa2kuYW1hem9u
LmNvbS9jcnQvQW1hem9uLmNvbSUyMEludGVybmFsJTIwUm9vdCUyMENlcnRpZmlj
YXRlJTIwQXV0aG9yaXR5LmNydDANBgkqhkiG9w0BAQsFAAOCAQEAzqXlffrnlFST
uMl7mIzzr4MofR5Kdh5b3LZQVIJtw+c9isOPf4FYXX2GUPOvyBe6Rrdiy4TMCvNR
Gs6D+HqoiEwxH0yM01RGq1bmw4G/mJ6hb6XPqGySDXmLbLH3w+JBT9uiKjRXkEFN
ghYweTFG8Efiz3OZZ8H1SIIJZRuG4kLBgV99I12iqnF0oErnoqwXW+ceAlQWNYvf
FG7b/2rxi8nur7REfo6QNiWr57LatEqECFqHTY41BKhGMY+vAdIQvnOqZWgkJlit
yzlkIBfKWil7HtCE8wRSsqYISQHzSeyYyRtbJl6GRUmFR8CKCak9RFINjgRxA+tD
Trc3i8PzQA==
-----END CERTIFICATE-----`),

	// CIA-CRT-G3-01.ant.amazon.com_Amazon.com CIA CA G3 01
	[]byte(`-----BEGIN CERTIFICATE-----
MIIFjjCCBHagAwIBAgIKYRld5QAAAAAAHjANBgkqhkiG9w0BAQsFADA5MTcwNQYD
VQQDEy5BbWF6b24uY29tIEludGVybmFsIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
aXR5MB4XDTE2MTExNjIwMTcxNFoXDTIxMTExNjIwMjcxNFowZDETMBEGCgmSJomT
8ixkARkWA2NvbTEWMBQGCgmSJomT8ixkARkWBmFtYXpvbjETMBEGCgmSJomT8ixk
ARkWA2FudDEgMB4GA1UEAxMXQW1hem9uLmNvbSBDSUEgQ0EgRzMgMDEwggIiMA0G
CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC/WnAhfwyRyDKn2dODY8rNoDjIWsCF
VzEBzH6zjhMDWTvHx1AsqhYOcuz8Ke+aWPTcLsKYtwmlGrf/EIBuAWRwMOdIjz5j
SujgMUf2JA3wLH4ngqCJRSPeFQ/DBoWIkHXwMeFW+xthZ6j5u6AgVJm99aeNLMnB
0d8BKGzPH4SuI0rZq8QRmTTfnXA+E5Njd227urmKEcf0ELUbBI9e92d/01Yrw549
FISyD61dnHDeKKYTjXhte/lKEmX1sQV8AzhvB+awuv0iBz2a/YNEp5YKm/D939vl
aaMRrIbe3dZSTrNsIb2PquA9PPvwgMEyhA5YrJthHhnFg7loDiTlp7w0xpwAY2+b
LV1QWknwg85patY+Zol0nWt8XgOTJqU/vGSs2OTEZO8EGJ8Uu7Dvz2/aEBeqSZfD
QzNV+Ob5FAo5RuV03l+gq+4dYQ58CSzV0dQ3Gdh5iRQHC2q0Oqe/fMPf//evWn0T
7eZVYNgf90pAcD9ZoxVCFRsCgeYNDPk6FmiTWGurzINVG7OMTF1nPH+PdVZqFjbF
L9aL6G/IbuabbrwCo9R6r6qxHMF8M5B/hJz6A8v872aT8YfKIB5OQAulK9LX6H3P
WpWcVzT+iRNVnSzQfSFeSxJfS6YLJSToGmBpuWxIbmCOVwRtjPVXhrVh8uvULQXf
qGEi32AqsXOOdQIDAQABo4IBazCCAWcwEAYJKwYBBAGCNxUBBAMCAQAwHQYDVR0O
BBYEFOGbI9IGsons6AkNJnf2AS/WJ3VmMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
QwBBMAsGA1UdDwQEAwIBhjASBgNVHRMBAf8ECDAGAQH/AgEAMB8GA1UdIwQYMBaA
FH+NsU5MopgK3Isnv2IFaTwlErPCMGUGA1UdHwReMFwwWqBYoFaGVGh0dHA6Ly9w
a2kuYW1hem9uLmNvbS9jcmwvQW1hem9uLmNvbSUyMEludGVybmFsJTIwUm9vdCUy
MENlcnRpZmljYXRlJTIwQXV0aG9yaXR5LmNybDBwBggrBgEFBQcBAQRkMGIwYAYI
KwYBBQUHMAKGVGh0dHA6Ly9wa2kuYW1hem9uLmNvbS9jcnQvQW1hem9uLmNvbSUy
MEludGVybmFsJTIwUm9vdCUyMENlcnRpZmljYXRlJTIwQXV0aG9yaXR5LmNydDAN
BgkqhkiG9w0BAQsFAAOCAQEAFZSZhNyxv26sAFed7JyvF01h4BJfObdpABrxLbXw
SJsjIwhG67RhiGEEX75bp4faTm4NvduF3lTvDzRxLEnWVUlEbu5V2+P1uJRZPszz
DLDcxXcWk13uKNG52J/8+uXdJ8mdm4TCEzK9K7mf9VdlZRgjoj7iK7I29xP2HFcX
HA7yNVoc3gcFinZQBn63ME+l1lgeqQbdHtUAKYyHm0KREV5UYQToC+Oq+DNDEBIj
j5VbJtpKqQ9hsdOXQj/dPB3DH+QLyrqiaLXNSgNxTLdnv7hjAKzVkFj0zKiOpEWF
wCMxPaG7rxCgCJ98KnZ5hvUqdyPL6mfnUij5BJkhVbYpZw==
-----END CERTIFICATE-----`),

	// CIA-CRT-G3-02.ant.amazon.com_Amazon.com CIA CA G3 02
	[]byte(`-----BEGIN CERTIFICATE-----
MIIFjjCCBHagAwIBAgIKYRqyGwAAAAAAHzANBgkqhkiG9w0BAQsFADA5MTcwNQYD
VQQDEy5BbWF6b24uY29tIEludGVybmFsIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
aXR5MB4XDTE2MTExNjIwMTg0MVoXDTIxMTExNjIwMjg0MVowZDETMBEGCgmSJomT
8ixkARkWA2NvbTEWMBQGCgmSJomT8ixkARkWBmFtYXpvbjETMBEGCgmSJomT8ixk
ARkWA2FudDEgMB4GA1UEAxMXQW1hem9uLmNvbSBDSUEgQ0EgRzMgMDIwggIiMA0G
CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDWpXSa9hn2uRqHxooA4pmj1TVMrEtk
OYFpyXSMvX2WT1drILicklAPyd/i8n4vAmdf2RfTjhjwf0/O8uYdfYB6or1JmqSl
QbJ3fHzbi91AN9quja8o2253NiaxBNCjyoC523Cnmou84e3t283waXE5umWZpNvw
Q9StDiOv98EhFfsV9tS06umQoG+MKawaAAbRY1ezi9EgeHQxPqcFkzIUBhA69pZ0
o7zVnCAvZ8/GrqebIiQPuKafTJmu6wLpdd/2igXSWKMntC9Ajm2RWK3ROo7rAILU
9BuhyTqjHPfwrGEN7+8UYIHy3HZL+0hscuTHsEg1455zVWYFt2g/T5f9SzXoPtlJ
Zbcp/eQqwzIUWhbYwu2WyQPy3sSUOacyqktdlVWCzk+mBZMCmX1WKTP9BImJV6JZ
FzeQGNDkK6ITpIjTt+5fbhFg9TPkroca4/IeYERknkizMPQbMwDM8jqpIQuwJXkv
MtIFVEmFrDiUI3IuEHPbg+v7FHiy5vaDmNwAVKgiAA4/S3db0pRqtzIKFJu67Wd4
h+v0f9kGcH2PIH4IWGV7uvOMB+z/qybOclV2QArSoyMyDKVecTs17aH2GtDIWc+G
c56jN/qX+LQxhOhYYADEeToql8w29Rig+KmzBorRI6ZrVFsReQSOIrwXsF6+gpd1
lNkMxi7rMeTsZQIDAQABo4IBazCCAWcwEAYJKwYBBAGCNxUBBAMCAQAwHQYDVR0O
BBYEFPQXz5/zB6GuqYGj0JedIIdtE3lCMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
QwBBMAsGA1UdDwQEAwIBhjASBgNVHRMBAf8ECDAGAQH/AgEAMB8GA1UdIwQYMBaA
FH+NsU5MopgK3Isnv2IFaTwlErPCMGUGA1UdHwReMFwwWqBYoFaGVGh0dHA6Ly9w
a2kuYW1hem9uLmNvbS9jcmwvQW1hem9uLmNvbSUyMEludGVybmFsJTIwUm9vdCUy
MENlcnRpZmljYXRlJTIwQXV0aG9yaXR5LmNybDBwBggrBgEFBQcBAQRkMGIwYAYI
KwYBBQUHMAKGVGh0dHA6Ly9wa2kuYW1hem9uLmNvbS9jcnQvQW1hem9uLmNvbSUy
MEludGVybmFsJTIwUm9vdCUyMENlcnRpZmljYXRlJTIwQXV0aG9yaXR5LmNydDAN
BgkqhkiG9w0BAQsFAAOCAQEAzpJgQgOEXFGbq6zFiqXNsDv2RZtoVtSG3eGKibSY
o85GSMPA6w6Vw8udB9K1EPeZLtf6QjEeL4ii04/58FPf+oRd9zPYx25AsaiqdVhZ
V4REepw0gDGeLzDFnUqlqd6FzwsWLY9hgHR/qcGrHupCB10UZrrklSWWpN7qGLxA
oqwWRWJV03IpwsqQQ2V1jfmRvK8V228sz1BU9kJL7QR9XTHqdCpfjWR+VPJrmB4X
2w2hgI9S8BSYi6eU6P/fX20okBnw5zhCZhyanHB+OblYH6+54tAOF+DKBF78kOHm
6ToFKHFijzo07KBky/dJP9wPTnzY+/Maw0PyLURW+++++Q==
-----END CERTIFICATE-----`),
}
