// Code generated by protoc-gen-twirp v4.4.0, DO NOT EDIT.
// source: code.justin.tv/release/trace/internal/ext/guardian_v1/guardian.proto

/*
Package guardian_v1 is a generated twirp stub package.
This code was generated with code.justin.tv/common/twirp/protoc-gen-twirp v4.4.0.

It is generated from these files:
	code.justin.tv/release/trace/internal/ext/guardian_v1/guardian.proto
*/
package guardian_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

import bytes "bytes"
import strconv "strconv"
import context "golang.org/x/net/context"
import http "net/http"
import ioutil "io/ioutil"
import jsonpb "github.com/golang/protobuf/jsonpb"
import log "log"
import proto1 "github.com/golang/protobuf/proto"
import twirp "code.justin.tv/common/twirp"
import fmt1 "fmt"

// Imports only used by utility functions:
import io "io"
import strings "strings"
import json "encoding/json"
import url "net/url"
import ctxhttp "golang.org/x/net/context/ctxhttp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ==================
// Guardian Interface
// ==================

// Manages Twitch-internal OAuth2 applications and provides access to LDAP
// users and groups.
type Guardian interface {
	// Lists all LDAP users.
	//
	// No authentication required.
	ListUsers(context.Context, *ListUsersRequest) (*ListUsersResponse, error)

	// Gets details of a single LDAP user, including the names (`cn`) of all
	// groups of which the user is a member.
	//
	// No authentication required.
	GetUser(context.Context, *GetUserRequest) (*GetUserResponse, error)

	// Lists all LDAP groups.
	//
	// No authentication required.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)

	// Gets details of a single LDAP group, including the full names (`cn`) of
	// all member users.
	//
	// No authentication required.
	GetGroup(context.Context, *GetGroupRequest) (*GetGroupResponse, error)

	// Lists all Twitch-internal OAuth2 client applications.
	//
	// Authentication is required.
	ListClients(context.Context, *ListClientsRequest) (*ListClientsResponse, error)

	// Gets details of a single Twitch-internal OAuth2 client application.
	//
	// Authentication is required.
	GetClient(context.Context, *GetClientRequest) (*GetClientResponse, error)

	// Creates a Twitch-internal OAuth2 client application.
	//
	// Authentication is required. Content-Type must be
	// `application/vnd.api+json`. See the request message for details on which
	// fields must be set.
	CreateClient(context.Context, *CreateClientRequest) (*CreateClientResponse, error)

	// Updates a Twitch-internal OAuth2 client application.
	//
	// Authentication is required. Content-Type must be
	// `application/vnd.api+json`. See the request message for details on which
	// fields must be set.
	UpdateClient(context.Context, *UpdateClientRequest) (*UpdateClientResponse, error)

	// Deletes a Twitch-internal OAuth2 client application.
	//
	// Authentication is required.
	DeleteClient(context.Context, *DeleteClientRequest) (*google_protobuf1.Empty, error)
}

// ========================
// Guardian Protobuf Client
// ========================

type guardianProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewGuardianProtobufClient creates a Protobuf client that implements the Guardian interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewGuardianProtobufClient(addr string, client *http.Client) Guardian {
	return &guardianProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *guardianProtobufClient) ListUsers(ctx context.Context, in *ListUsersRequest) (*ListUsersResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "ListUsers"
	out := new(ListUsersResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianProtobufClient) GetUser(ctx context.Context, in *GetUserRequest) (*GetUserResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "GetUser"
	out := new(GetUserResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianProtobufClient) ListGroups(ctx context.Context, in *ListGroupsRequest) (*ListGroupsResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "ListGroups"
	out := new(ListGroupsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianProtobufClient) GetGroup(ctx context.Context, in *GetGroupRequest) (*GetGroupResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "GetGroup"
	out := new(GetGroupResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianProtobufClient) ListClients(ctx context.Context, in *ListClientsRequest) (*ListClientsResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "ListClients"
	out := new(ListClientsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianProtobufClient) GetClient(ctx context.Context, in *GetClientRequest) (*GetClientResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "GetClient"
	out := new(GetClientResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianProtobufClient) CreateClient(ctx context.Context, in *CreateClientRequest) (*CreateClientResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "CreateClient"
	out := new(CreateClientResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianProtobufClient) UpdateClient(ctx context.Context, in *UpdateClientRequest) (*UpdateClientResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "UpdateClient"
	out := new(UpdateClientResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianProtobufClient) DeleteClient(ctx context.Context, in *DeleteClientRequest) (*google_protobuf1.Empty, error) {
	url := c.urlBase + GuardianPathPrefix + "DeleteClient"
	out := new(google_protobuf1.Empty)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

// ====================
// Guardian JSON Client
// ====================

type guardianJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewGuardianJSONClient creates a JSON client that implements the Guardian interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewGuardianJSONClient(addr string, client *http.Client) Guardian {
	return &guardianJSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *guardianJSONClient) ListUsers(ctx context.Context, in *ListUsersRequest) (*ListUsersResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "ListUsers"
	out := new(ListUsersResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianJSONClient) GetUser(ctx context.Context, in *GetUserRequest) (*GetUserResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "GetUser"
	out := new(GetUserResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianJSONClient) ListGroups(ctx context.Context, in *ListGroupsRequest) (*ListGroupsResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "ListGroups"
	out := new(ListGroupsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianJSONClient) GetGroup(ctx context.Context, in *GetGroupRequest) (*GetGroupResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "GetGroup"
	out := new(GetGroupResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianJSONClient) ListClients(ctx context.Context, in *ListClientsRequest) (*ListClientsResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "ListClients"
	out := new(ListClientsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianJSONClient) GetClient(ctx context.Context, in *GetClientRequest) (*GetClientResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "GetClient"
	out := new(GetClientResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianJSONClient) CreateClient(ctx context.Context, in *CreateClientRequest) (*CreateClientResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "CreateClient"
	out := new(CreateClientResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianJSONClient) UpdateClient(ctx context.Context, in *UpdateClientRequest) (*UpdateClientResponse, error) {
	url := c.urlBase + GuardianPathPrefix + "UpdateClient"
	out := new(UpdateClientResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *guardianJSONClient) DeleteClient(ctx context.Context, in *DeleteClientRequest) (*google_protobuf1.Empty, error) {
	url := c.urlBase + GuardianPathPrefix + "DeleteClient"
	out := new(google_protobuf1.Empty)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

// =======================
// Guardian Server Handler
// =======================

type guardianServer struct {
	Guardian
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewGuardianServer(svc Guardian, hooks *twirp.ServerHooks, ctxSrc ContextSource) http.Handler {
	if hooks == nil {
		hooks = twirp.NewServerHooks()
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}
	return &guardianServer{svc, hooks, ctxSrc}
}

// GuardianPathPrefix is used for all URL paths on a twirp Guardian server.
// Requests are always: POST GuardianPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const GuardianPathPrefix = "/twirp/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/"

// GuardianPathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const GuardianPathPrefixOld = "/v2/code_justin_tv.release.trace.internal.ext.guardian.v1.Guardian/"

func (s *guardianServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "Guardian")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt1.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
		return
	}

	switch req.URL.Path {
	case GuardianPathPrefix + "ListUsers", GuardianPathPrefixOld + "ListUsers", "/v1/Guardian/ListUsers":
		s.serveListUsers(ctx, resp, req)
		return
	case GuardianPathPrefix + "GetUser", GuardianPathPrefixOld + "GetUser", "/v1/Guardian/GetUser":
		s.serveGetUser(ctx, resp, req)
		return
	case GuardianPathPrefix + "ListGroups", GuardianPathPrefixOld + "ListGroups", "/v1/Guardian/ListGroups":
		s.serveListGroups(ctx, resp, req)
		return
	case GuardianPathPrefix + "GetGroup", GuardianPathPrefixOld + "GetGroup", "/v1/Guardian/GetGroup":
		s.serveGetGroup(ctx, resp, req)
		return
	case GuardianPathPrefix + "ListClients", GuardianPathPrefixOld + "ListClients", "/v1/Guardian/ListClients":
		s.serveListClients(ctx, resp, req)
		return
	case GuardianPathPrefix + "GetClient", GuardianPathPrefixOld + "GetClient", "/v1/Guardian/GetClient":
		s.serveGetClient(ctx, resp, req)
		return
	case GuardianPathPrefix + "CreateClient", GuardianPathPrefixOld + "CreateClient", "/v1/Guardian/CreateClient":
		s.serveCreateClient(ctx, resp, req)
		return
	case GuardianPathPrefix + "UpdateClient", GuardianPathPrefixOld + "UpdateClient", "/v1/Guardian/UpdateClient":
		s.serveUpdateClient(ctx, resp, req)
		return
	case GuardianPathPrefix + "DeleteClient", GuardianPathPrefixOld + "DeleteClient", "/v1/Guardian/DeleteClient":
		s.serveDeleteClient(ctx, resp, req)
		return
	default:
		msg := fmt1.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
		return
	}
}

// Make HTTP response from an error.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *guardianServer) serveError(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		s.serveErrorV1V2(ctx, resp, req, err)
	} else {
		s.serveErrorV3Plus(ctx, resp, req, err)
	}
}

// v3+ error responses.
func (s *guardianServer) serveErrorV3Plus(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = setStatusCode(ctx, statusCode)
	ctx = s.hooks.Error(ctx, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}
	_ = s.hooks.ResponseSent(ctx)
}

// v1/v2 backwards-compatible error responses.
// To make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func (s *guardianServer) serveErrorV1V2(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (BadRoute)
	var v2ErrorID string
	if twerr.Code() == twirp.BadRoute {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	ctx = setStatusCode(ctx, statusCode)
	ctx = s.hooks.Error(ctx, twerr)
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveListUsers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListUsersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUsersProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveListUsersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUsers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListUsersRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUsers(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ListUsersResponse and nil error while calling ListUsers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveListUsersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUsers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUsersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUsersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUsers(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ListUsersResponse and nil error while calling ListUsers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveGetUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveGetUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUser")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetUserResponse and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveGetUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUser")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetUserResponse and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveListGroups(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListGroupsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListGroupsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveListGroupsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListGroups")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListGroupsRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListGroupsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListGroups(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ListGroupsResponse and nil error while calling ListGroups. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveListGroupsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListGroups")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListGroupsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListGroupsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListGroups(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ListGroupsResponse and nil error while calling ListGroups. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveGetGroup(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGroupJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGroupProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveGetGroupJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGroup")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGroupRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGroupResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGroup(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetGroupResponse and nil error while calling GetGroup. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveGetGroupProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGroup")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGroupRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGroupResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGroup(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetGroupResponse and nil error while calling GetGroup. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveListClients(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListClientsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListClientsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveListClientsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListClients")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListClientsRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListClientsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListClients(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ListClientsResponse and nil error while calling ListClients. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveListClientsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListClients")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListClientsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListClientsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListClients(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ListClientsResponse and nil error while calling ListClients. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveGetClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetClientProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveGetClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetClient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetClientRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetClient(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetClientResponse and nil error while calling GetClient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveGetClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetClient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetClientRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetClient(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetClientResponse and nil error while calling GetClient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveCreateClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateClientProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveCreateClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateClient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateClientRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateClient(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *CreateClientResponse and nil error while calling CreateClient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveCreateClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateClient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateClientRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateClient(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *CreateClientResponse and nil error while calling CreateClient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveUpdateClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateClientProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveUpdateClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateClient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateClientRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateClient(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *UpdateClientResponse and nil error while calling UpdateClient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveUpdateClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateClient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateClientRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateClient(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *UpdateClientResponse and nil error while calling UpdateClient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveDeleteClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveDeleteClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteClientProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *guardianServer) serveDeleteClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DeleteClient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(DeleteClientRequest)
	if err = jsonpb.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteClient(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling DeleteClient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *guardianServer) serveDeleteClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DeleteClient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteClientRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteClient(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling DeleteClient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

// =====
// Utils
// =====

// A ContextSource establishes the base context for a Server.
type ContextSource func(http.ResponseWriter, *http.Request) context.Context

var RequestContextSource ContextSource = func(w http.ResponseWriter, req *http.Request) context.Context {
	return req.Context()
}

var BackgroundContextSource ContextSource = func(http.ResponseWriter, *http.Request) context.Context {
	return context.Background()
}

// done returns ctx.Err() if ctx.Done() indicates that the context done
func done(ctx context.Context) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	default:
		return nil
	}
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// setMethodName, setServerName, and setStatusCode are functions to
// expose internal state through contexts. The context keys hardcoded
// in here are not to be used on their own. Twirp provides accessor
// functions which will retrieve these values out and give them the
// correct type for you.
func setMethodName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_method_name", name)
}
func setServerName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_service_name", name)
}
func setStatusCode(ctx context.Context, code int) context.Context {
	return context.WithValue(ctx, "__tw_status_code", strconv.Itoa(code))
}

type privateContextKey int

var versionKey = new(privateContextKey)

// setVersionFromPath adds "v1", "v2" or "v3" to the context depending on the path.
func setVersionFromPath(ctx context.Context, path string) context.Context {
	var version string
	if strings.HasPrefix(path, "/v1/") {
		version = "v1"
	} else if strings.HasPrefix(path, "/v2/") {
		version = "v2"
	} else {
		version = "v3"
	}
	return context.WithValue(ctx, versionKey, version)
}

// getVersion returns the version number ("v1", "v2", "v3") or empty string if unset.
func getVersion(ctx context.Context) string {
	v, _ := ctx.Value(versionKey).(string)
	return v
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := ctx.Value("__tw_request_header").(http.Header)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// closebody closes a response or request body and just logs
// any error encountered while closing, since errors are
// considered very unusual.
func closebody(body io.Closer) {
	if err := body.Close(); err != nil {
		log.Printf("error closing body: %q", err)
	}
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v4.4.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients dont't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt1.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt1.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtoRequest is common code to make a request to the remote twirp service.
func doProtoRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto1.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	if err = jsonpb.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}
