package persistent

import (
	"context"
	"time"

	"code.justin.tv/release/trace"
	"code.justin.tv/release/trace/api"
	"code.justin.tv/release/trace/api/report_v1"
)

type ReportIndex interface {
	List(ctx context.Context) ([]Report, error)
}

type Report interface {
	ID() string
	ModTime() time.Time
	Pluck(ctx context.Context, id *trace.ID) (*api.Transaction, error)
	ListServers(ctx context.Context) ([]string, error)
	Content(ctx context.Context, programName string) (*report_v1.ProgramReport, error)
}
