#!/usr/bin/env bash
set -e -o pipefail -u -x

version="$1"                      # "23540/3"
cl="${version%/*}"                # read until slash: "23540"
patch="${version:$((${#cl}+1))}"  # part after slash: "3"
prefix="${cl:$((${#cl}-2)):2}"    # last two chars of $cl: "40"

if [[ -z "$patch" ]]; then
	set +x
	echo >&2 "Usage: $0 CL/PS"
	echo >&2 ""
	echo >&2 "You must specify both a changelist and patchset, such as"
	echo >&2 "    \$ $0 23540/3 [cherry-pick]"
	echo >&2 "to download and build PS 3 of CL 23540, optionally"
	echo >&2 "cherry-picking it onto the previously selected Go version"
	exit 1
fi

# Fetch and build a specific patch to Go.
cd /usr/local/go-tip
git fetch https://go.googlesource.com/go "refs/changes/$prefix/$cl/$patch"
if [[ "${2:-}" == "cherry-pick" ]]; then
	git cherry-pick FETCH_HEAD
	rm VERSION || true
else
	git checkout FETCH_HEAD
fi

cd /usr/local/go-tip/src
GOROOT_FINAL=/usr/local/go GOROOT_BOOTSTRAP=/usr/local/go-bootstrap ./make.bash
