#!/bin/sh
set -eo pipefail

source ./jenkins/common.sh

rm -rf .manta/ $BUILD
mkdir -p $BUILD

sh ./scripts/lint.sh

manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f .manta.json
manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f .manta.fpm.json

cp -rf cmd/scripts .manta/dest/

# need to access jenkins scripts during deployment
cp -r jenkins $BUILD

# TODO: only temporary to get the jenkins build working
# everything should just be output to build
cp -r .manta/dest/* $BUILD
cp .manta/*.log $BUILD || true
