#!/bin/sh
set -eo pipefail

source ./jenkins/common.sh

rm -rf .manta/ build/
mkdir -p build
echo 'full-test: starting full tests'
manta -update -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f .manta.full.json
sh ./scripts/lint.sh
cp .manta/dest/test_report.xml test_report.xml

# need to access jenkins scripts during deployment
cp -r jenkins build

# TODO: only temporary to get the jenkins build working
# everything should just be output to build
cp -r .manta/dest/* build
cp .manta/*.log build || true
cp -r .manta/dest build
